/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreEventTask;
import org.apache.accumulo.server.conf.store.impl.ReadyMonitor;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropStoreWatcher
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(PropStoreWatcher.class);
    private static final ExecutorService executorService = ThreadPools.getServerThreadPools().getPoolBuilder("prop.store.zoo.change.update").numCoreThreads(2).build();
    private final ReentrantReadWriteLock listenerLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock listenerReadLock = this.listenerLock.readLock();
    private final ReentrantReadWriteLock.WriteLock listenerWriteLock = this.listenerLock.writeLock();
    private final Map<PropStoreKey<?>, Set<PropChangeListener>> listeners = new HashMap();
    private final ReadyMonitor zkReadyMonitor;

    public PropStoreWatcher(ReadyMonitor zkReadyMonitor) {
        this.zkReadyMonitor = zkReadyMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(PropStoreKey<?> propStoreKey, PropChangeListener listener) {
        this.listenerWriteLock.lock();
        try {
            Set set = this.listeners.computeIfAbsent(propStoreKey, s -> new HashSet());
            set.add(listener);
        }
        finally {
            this.listenerWriteLock.unlock();
        }
    }

    public void process(WatchedEvent event) {
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                String path = event.getPath();
                log.trace("handle change event for path: {}", (Object)path);
                PropStoreKey<?> propStoreKey = PropStoreKey.fromPath(path);
                if (propStoreKey == null) break;
                this.signalZkChangeEvent(propStoreKey);
                break;
            }
            case NodeDeleted: {
                String path = event.getPath();
                log.trace("handle delete event for path: {}", (Object)path);
                PropStoreKey<?> propStoreKey = PropStoreKey.fromPath(path);
                if (propStoreKey == null) break;
                Set<PropChangeListener> snapshot = this.getListenerSnapshot(propStoreKey);
                if (snapshot != null) {
                    executorService.execute(new PropStoreEventTask.PropStoreDeleteEventTask(propStoreKey, snapshot));
                }
                this.listenerCleanup(propStoreKey);
                break;
            }
            case None: {
                Watcher.Event.KeeperState state = event.getState();
                switch (state) {
                    case ConnectedReadOnly: 
                    case Disconnected: {
                        log.debug("ZooKeeper disconnected event received");
                        this.zkReadyMonitor.clearReady();
                        executorService.execute(new PropStoreEventTask.PropStoreConnectionEventTask(this.getAllListenersSnapshot()));
                        break block0;
                    }
                    case SyncConnected: {
                        log.debug("ZooKeeper connected event received");
                        this.zkReadyMonitor.setReady();
                        break block0;
                    }
                    case Expired: 
                    case Closed: {
                        log.info("ZooKeeper connection closed event received");
                        this.zkReadyMonitor.clearReady();
                        this.zkReadyMonitor.setClosed();
                        executorService.execute(new PropStoreEventTask.PropStoreConnectionEventTask(this.getAllListenersSnapshot()));
                        break block0;
                    }
                }
                log.trace("ignoring zooKeeper state: {}", (Object)state);
                break;
            }
        }
    }

    public void signalZkChangeEvent(@NonNull PropStoreKey<?> propStoreKey) {
        log.trace("signal ZooKeeper change event: {}", propStoreKey);
        Set<PropChangeListener> snapshot = this.getListenerSnapshot(propStoreKey);
        log.trace("Sending change event to: {}", snapshot);
        if (snapshot != null) {
            executorService.execute(new PropStoreEventTask.PropStoreZkChangeEventTask(propStoreKey, snapshot));
        }
    }

    public void signalCacheChangeEvent(PropStoreKey<?> propStoreKey) {
        log.trace("cache change event: {}", propStoreKey);
        Set<PropChangeListener> snapshot = this.getListenerSnapshot(propStoreKey);
        if (snapshot != null) {
            executorService.execute(new PropStoreEventTask.PropStoreCacheChangeEventTask(propStoreKey, snapshot));
        }
    }

    public void listenerCleanup(PropStoreKey<?> propStoreKey) {
        this.listenerWriteLock.lock();
        try {
            this.listeners.remove(propStoreKey);
        }
        finally {
            this.listenerWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<PropChangeListener> getListenerSnapshot(PropStoreKey<?> propStoreKey) {
        Set<PropChangeListener> snapshot = null;
        this.listenerReadLock.lock();
        try {
            Set<PropChangeListener> set = this.listeners.get(propStoreKey);
            if (set != null) {
                snapshot = Set.copyOf(set);
            }
        }
        finally {
            this.listenerReadLock.unlock();
        }
        return snapshot;
    }

    private Set<PropChangeListener> getAllListenersSnapshot() {
        this.listenerReadLock.lock();
        try {
            Set set = this.listeners.keySet().stream().flatMap(key -> this.listeners.get(key).stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            return set;
        }
        finally {
            this.listenerReadLock.unlock();
        }
    }
}

