/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionPlanner;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.util.ConfigurationImpl;
import org.apache.accumulo.core.util.compaction.CompactionPlannerInitParams;
import org.apache.accumulo.core.util.compaction.CompactionServicesConfig;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class CheckCompactionConfig
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(CheckCompactionConfig.class);
    static final String DEFAULT = "default";
    static final String META = "meta";
    static final String ROOT = "root";

    public String keyword() {
        return "check-compaction-config";
    }

    public String description() {
        return "Verifies compaction config within a given file";
    }

    public static void main(String[] args) throws Exception {
        new CheckCompactionConfig().execute(args);
    }

    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(this.keyword(), args, new Object[0]);
        if (opts.filePath == null) {
            throw new IllegalArgumentException("No properties file was given");
        }
        Path path = Path.of(opts.filePath, new String[0]);
        if (!path.toFile().exists()) {
            throw new FileNotFoundException("File at given path could not be found");
        }
        SiteConfiguration config = SiteConfiguration.fromFile((File)path.toFile()).build();
        CheckCompactionConfig.validate((AccumuloConfiguration)config);
    }

    public static void validate(AccumuloConfiguration config) throws ReflectiveOperationException, SecurityException, IllegalArgumentException {
        CompactionServicesConfig servicesConfig = new CompactionServicesConfig(config, arg_0 -> ((Logger)log).warn(arg_0));
        ServiceEnvironment senv = CheckCompactionConfig.createServiceEnvironment(config);
        Set<String> defaultServices = Set.of(DEFAULT, META, ROOT);
        if (servicesConfig.getPlanners().keySet().equals(defaultServices)) {
            log.warn("Only the default compaction services were created - {}", defaultServices);
            return;
        }
        for (Map.Entry entry : servicesConfig.getPlanners().entrySet()) {
            String serviceId = (String)entry.getKey();
            String plannerClassName = (String)entry.getValue();
            log.info("Service id: {}, planner class:{}", (Object)serviceId, (Object)plannerClassName);
            Class<CompactionPlanner> plannerClass = Class.forName(plannerClassName).asSubclass(CompactionPlanner.class);
            CompactionPlanner planner = plannerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            CompactionPlannerInitParams initParams = new CompactionPlannerInitParams(CompactionServiceId.of((String)serviceId), (Map)servicesConfig.getOptions().get(serviceId), senv);
            planner.init((CompactionPlanner.InitParameters)initParams);
            initParams.getRequestedExecutors().forEach((execId, numThreads) -> log.info("Compaction service '{}' requested creation of thread pool '{}' with {} threads.", new Object[]{serviceId, execId, numThreads}));
            initParams.getRequestedExternalExecutors().forEach(execId -> log.info("Compaction service '{}' requested with external execution queue '{}'", (Object)serviceId, execId));
        }
        log.info("Properties file has passed all checks.");
    }

    private static ServiceEnvironment createServiceEnvironment(final AccumuloConfiguration config) {
        return new ServiceEnvironment(){

            public <T> T instantiate(TableId tableId, String className, Class<T> base) {
                throw new UnsupportedOperationException();
            }

            public <T> T instantiate(String className, Class<T> base) {
                throw new UnsupportedOperationException();
            }

            public String getTableName(TableId tableId) {
                throw new UnsupportedOperationException();
            }

            public ServiceEnvironment.Configuration getConfiguration(TableId tableId) {
                return new ConfigurationImpl(config);
            }

            public ServiceEnvironment.Configuration getConfiguration() {
                return new ConfigurationImpl(config);
            }
        };
    }

    static class Opts
    extends Help {
        @Parameter(description="<path> Local path to file containing compaction configuration", required=true)
        String filePath;

        Opts() {
        }
    }
}

