/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.logging;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;
import org.apache.accumulo.server.ServerContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="AccumuloMonitor", category="Core", elementType="appender", printObject=true)
public class AccumuloMonitorAppender
extends AbstractAppender {
    private final Gson gson = new Gson();
    private final HttpClient httpClient;
    private final Supplier<Optional<URI>> monitorLocator;
    private final ThreadPoolExecutor executor;
    private final boolean async;
    private final int queueSize;
    private final AtomicLong appends = new AtomicLong(0L);
    private final AtomicLong discards = new AtomicLong(0L);
    private final AtomicLong errors = new AtomicLong(0L);
    private final ConcurrentMap<Integer, AtomicLong> statusCodes = new ConcurrentSkipListMap<Integer, AtomicLong>();
    private ServerContext context;
    private String path;
    private Pair<Long, Optional<URI>> lastResult = new Pair((Object)0L, Optional.empty());

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private AccumuloMonitorAppender(String name, Filter filter, boolean ignoreExceptions, Property[] properties, int queueSize, int maxThreads, boolean async) {
        super(name, filter, null, ignoreExceptions, properties);
        this.executor = async ? new ThreadPoolExecutor(0, maxThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()) : null;
        HttpClient.Builder builder = HttpClient.newBuilder();
        this.httpClient = (async ? builder.executor(this.executor) : builder).build();
        this.queueSize = queueSize;
        this.async = async;
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        this.monitorLocator = () -> {
            if (this.context == null) {
                this.context = new ServerContext(SiteConfiguration.auto());
                this.path = this.context.getZooKeeperRoot() + "/monitor/http_addr";
            }
            byte[] loc = this.context.getZooCache().get(this.path, stat);
            Pair last = this.lastResult;
            if (stat.getMzxid() != ((Long)last.getFirst()).longValue()) {
                this.lastResult = last = new Pair((Object)stat.getMzxid(), Optional.ofNullable(loc).map(bytes -> URI.create(new String((byte[])bytes, StandardCharsets.UTF_8) + "rest/logs/append")));
            }
            return (Optional)last.getSecond();
        };
    }

    private String getStats() {
        return "discards:" + this.discards.get() + " errors:" + this.errors.get() + " appends:" + this.appends.get() + " statusCodes:" + String.valueOf(this.statusCodes);
    }

    private void processResponse(HttpResponse<?> response) {
        int statusCode = response.statusCode();
        this.statusCodes.computeIfAbsent(statusCode, sc -> new AtomicLong()).getAndIncrement();
        if (statusCode >= 400 && statusCode < 600) {
            this.error("Unable to send HTTP in appender [" + this.getName() + "]. Status: " + statusCode + " " + this.getStats());
        }
    }

    public void append(LogEvent event) {
        this.appends.getAndIncrement();
        this.monitorLocator.get().ifPresentOrElse(uri -> {
            try {
                SingleLogEvent pojo = new SingleLogEvent();
                pojo.timestamp = event.getTimeMillis();
                pojo.application = System.getProperty("accumulo.application", "unknown");
                pojo.logger = event.getLoggerName();
                pojo.level = event.getLevel().name();
                pojo.message = event.getMessage().getFormattedMessage();
                pojo.stacktrace = AccumuloMonitorAppender.throwableToStacktrace(event.getThrown());
                String jsonEvent = this.gson.toJson((Object)pojo);
                HttpRequest req = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofString(jsonEvent, StandardCharsets.UTF_8)).setHeader("Content-Type", "application/json").build();
                if (this.async) {
                    if (this.executor.getQueue().size() < this.queueSize) {
                        ((CompletableFuture)this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.discarding()).thenAccept(this::processResponse)).exceptionally(e -> {
                            this.errors.getAndIncrement();
                            this.error("Unable to send HTTP in appender [" + this.getName() + "] " + this.getStats(), event, (Throwable)e);
                            return null;
                        });
                    } else {
                        this.discards.getAndIncrement();
                        this.error("Unable to send HTTP in appender [" + this.getName() + "]. Queue full. " + this.getStats());
                    }
                } else {
                    this.processResponse(this.httpClient.send(req, HttpResponse.BodyHandlers.discarding()));
                }
            }
            catch (Exception e2) {
                this.errors.getAndIncrement();
                this.error("Unable to send HTTP in appender [" + this.getName() + "] " + this.getStats(), event, e2);
            }
        }, () -> {
            this.discards.getAndIncrement();
            this.error("Unable to send HTTP in appender [" + this.getName() + "]. No monitor is running. " + this.getStats());
        });
    }

    protected boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        if (changeLifeCycleState) {
            this.setStopping();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        return super.stop(timeout, timeUnit, changeLifeCycleState);
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="throwable is intended to be printed to output stream, to send to monitor")
    private static String throwableToStacktrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public String toString() {
        return "AccumuloMonitorAppender{name=" + this.getName() + ", state=" + String.valueOf(this.getState()) + "}";
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<AccumuloMonitorAppender> {
        @PluginBuilderAttribute
        private boolean async = true;
        @PluginBuilderAttribute
        private int queueSize = 1024;
        @PluginBuilderAttribute
        private int maxThreads = 2;

        public Builder setAsync(boolean async) {
            this.async = async;
            return this;
        }

        public boolean getAsync() {
            return this.async;
        }

        public Builder setQueueSize(int size) {
            this.queueSize = size;
            return this;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public Builder setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public AccumuloMonitorAppender build() {
            return new AccumuloMonitorAppender(this.getName(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), this.getQueueSize(), this.getMaxThreads(), this.getAsync());
        }
    }
}

