/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.compactor;

import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.accumulo.compactor.CompactionJobHolder;
import org.apache.accumulo.compactor.ExtCEnv;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.CompactorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TNextCompactionJob;
import org.apache.accumulo.core.compaction.thrift.UnknownCompactionIdException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.cluster.ClusterConfigParser;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ServiceLockSupport;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.InputFile;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionStats;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TIteratorSetting;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.CompactionWatcher;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.compaction.RetryableThriftCall;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compactor
extends AbstractServer
implements MetricsProducer,
CompactorService.Iface,
ServerProcessService.Iface {
    private static final SecureRandom random = new SecureRandom();
    private static final Logger LOG = LoggerFactory.getLogger(Compactor.class);
    private static final long TIME_BETWEEN_GC_CHECKS = 5000L;
    private static final long TEN_MEGABYTES = 0xA00000L;
    protected static final CompactionJobHolder JOB_HOLDER = new CompactionJobHolder();
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    private final UUID compactorId = UUID.randomUUID();
    private final String queueName;
    protected final AtomicReference<ExternalCompactionId> currentCompactionId = new AtomicReference();
    private ServiceLock compactorLock;
    private ServerAddress compactorAddress = null;
    private final AtomicBoolean compactionRunning = new AtomicBoolean(false);
    private final ConsecutiveErrorHistory errorHistory = new ConsecutiveErrorHistory();
    private final AtomicLong completed = new AtomicLong(0L);
    private final AtomicLong cancelled = new AtomicLong(0L);
    private final AtomicLong failed = new AtomicLong(0L);
    private final AtomicLong terminated = new AtomicLong(0L);

    protected Compactor(CompactorServerOpts opts, String[] args) {
        super("compactor", (ServerOpts)opts, args);
        this.queueName = opts.getQueueName();
        ClusterConfigParser.validateGroupNames(Set.of(this.queueName));
    }

    private long getTotalEntriesRead() {
        return FileCompactor.getTotalEntriesRead();
    }

    private long getTotalEntriesWritten() {
        return FileCompactor.getTotalEntriesWritten();
    }

    private double getConsecutiveFailures() {
        return this.errorHistory.getTotalFailures();
    }

    private double getCancellations() {
        return this.cancelled.get();
    }

    private double getCompletions() {
        return this.completed.get();
    }

    private double getFailures() {
        return this.failed.get();
    }

    private double getTerminated() {
        return this.terminated.get();
    }

    public void registerMetrics(MeterRegistry registry) {
        super.registerMetrics(registry);
        FunctionCounter.builder((String)"accumulo.compactor.entries.read", (Object)((Object)this), Compactor::getTotalEntriesRead).description("Number of entries read by all compactions that have run on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.entries.written", (Object)((Object)this), Compactor::getTotalEntriesWritten).description("Number of entries written by all compactions that have run on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.majc.cancelled", (Object)((Object)this), Compactor::getCancellations).description("Number compactions that have been cancelled on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.majc.completed", (Object)((Object)this), Compactor::getCompletions).description("Number compactions that have succeeded on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.majc.failed", (Object)((Object)this), Compactor::getFailures).description("Number compactions that have failed on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.terminated", (Object)((Object)this), Compactor::getTerminated).description("Will report 1 if the Compactor terminates due to consecutive failure, else 0").register(registry);
        Gauge.builder((String)"accumulo.compactor.majc.failures.consecutive", (Object)((Object)this), Compactor::getConsecutiveFailures).description("Number of consecutive compaction failures. Resets to zero on a successful compaction").register(registry);
        LongTaskTimer timer = LongTaskTimer.builder((String)"accumulo.compactor.majc.stuck").description("Number and duration of stuck major compactions").register(registry);
        CompactionWatcher.setTimer((LongTaskTimer)timer);
    }

    protected void startGCLogger(ScheduledThreadPoolExecutor schedExecutor) {
        ScheduledFuture<?> future = schedExecutor.scheduleWithFixedDelay(() -> this.gcLogger.logGCInfo(this.getConfiguration()), 0L, 5000L, TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void startCancelChecker(ScheduledThreadPoolExecutor schedExecutor, long timeBetweenChecks) {
        ThreadPools.watchCriticalScheduledTask(schedExecutor.scheduleWithFixedDelay(this::checkIfCanceled, 0L, timeBetweenChecks, TimeUnit.MILLISECONDS));
    }

    protected void checkIfCanceled() {
        TExternalCompactionJob job = JOB_HOLDER.getJob();
        if (job != null) {
            try {
                KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                ExternalCompactionId ecid = ExternalCompactionId.of((String)job.getExternalCompactionId());
                TabletMetadata tabletMeta = this.getContext().getAmple().readTablet(extent, new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP, TabletMetadata.ColumnType.PREV_ROW});
                if (tabletMeta == null || !tabletMeta.getExternalCompactions().containsKey(ecid)) {
                    LOG.info("Cancelling compaction {} that no longer has a metadata entry at {}", (Object)ecid, (Object)extent);
                    JOB_HOLDER.cancel(job.getExternalCompactionId());
                    return;
                }
                if (job.getKind() == TCompactionKind.USER) {
                    String zTablePath = "/accumulo/" + String.valueOf(this.getContext().getInstanceID()) + "/tables/" + String.valueOf(extent.tableId()) + "/compact-cancel-id";
                    byte[] id = this.getContext().getZooCache().get(zTablePath);
                    if (id == null) {
                        LOG.info("Cancelling compaction {} for table that no longer exists {}", (Object)ecid, (Object)extent);
                        JOB_HOLDER.cancel(job.getExternalCompactionId());
                    } else {
                        long cancelId = Long.parseLong(new String(id, StandardCharsets.UTF_8));
                        if (cancelId >= job.getUserCompactionId()) {
                            LOG.info("Cancelling compaction {} because user compaction was canceled", (Object)ecid);
                            JOB_HOLDER.cancel(job.getExternalCompactionId());
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to check if compaction {} for {} was canceled.", new Object[]{job.getExternalCompactionId(), KeyExtent.fromThrift((TKeyExtent)job.getExtent()), e});
            }
        }
    }

    protected void announceExistence(HostAndPort clientAddress) throws KeeperException, InterruptedException {
        String hostPort = ExternalCompactionUtil.getHostPortString((HostAndPort)clientAddress);
        ZooReaderWriter zoo = this.getContext().getZooReaderWriter();
        String compactorQueuePath = this.getContext().getZooKeeperRoot() + "/compactors/" + this.queueName;
        String zPath = compactorQueuePath + "/" + hostPort;
        try {
            zoo.mkdirs(compactorQueuePath);
            zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NOAUTH) {
                LOG.error("Failed to write to ZooKeeper. Ensure that accumulo.properties, specifically instance.secret, is consistent.");
            }
            throw e;
        }
        this.compactorLock = new ServiceLock(this.getContext().getZooReaderWriter().getZooKeeper(), ServiceLock.path((String)zPath), this.compactorId);
        ServiceLockSupport.ServiceLockWatcher lw = new ServiceLockSupport.ServiceLockWatcher("compactor", () -> this.getShutdownComplete().get(), name -> this.gcLogger.logGCInfo(this.getConfiguration()));
        try {
            byte[] lockContent = new ServerServices(hostPort, ServerServices.Service.COMPACTOR_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < 25; ++i) {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.compactorLock.tryLock((ServiceLock.LockWatcher)lw, lockContent)) {
                    LOG.debug("Obtained Compactor lock {}", (Object)this.compactorLock.getLockPath());
                    return;
                }
                LOG.info("Waiting for Compactor lock");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            LOG.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            LOG.info("Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected ServerAddress startCompactorClientService() throws UnknownHostException {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getCompactorTProcessor((ServerProcessService.Iface)this, (CompactorService.Iface)this, (ServerContext)this.getContext());
        Property maxMessageSizeProperty = this.getConfiguration().resolve(Property.RPC_MAX_MESSAGE_SIZE, new Property[]{Property.GENERAL_MAX_MESSAGE_SIZE});
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)this.getBindAddress(), (Property)Property.COMPACTOR_CLIENTPORT, (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.COMPACTOR_PORTSEARCH, (Property)Property.COMPACTOR_MINTHREADS, (Property)Property.COMPACTOR_MINTHREADS_TIMEOUT, (Property)Property.COMPACTOR_THREADCHECK, (Property)maxMessageSizeProperty);
        LOG.info("address = {}", (Object)sp.address);
        return sp;
    }

    private void cancel(String externalCompactionId) throws TException {
        if (!JOB_HOLDER.cancel(externalCompactionId)) {
            throw new UnknownCompactionIdException();
        }
        LOG.info("Cancel requested for compaction job {}", (Object)externalCompactionId);
    }

    public void cancel(TInfo tinfo, TCredentials credentials, String externalCompactionId) throws TException {
        TableId tableId = JOB_HOLDER.getTableId();
        try {
            NamespaceId nsId = this.getContext().getNamespaceId(tableId);
            if (!this.getContext().getSecurityOperation().canCompact(credentials, tableId, nsId)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.COMPACT_CANCEL, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        this.cancel(externalCompactionId);
    }

    protected void updateCompactionState(TExternalCompactionJob job, TCompactionStatusUpdate update) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                LOG.trace("Attempting to update compaction state in coordinator {}", (Object)job.getExternalCompactionId());
                coordinatorClient.updateCompactionStatus(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), update, System.currentTimeMillis());
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected void updateCompactionFailed(TExternalCompactionJob job, Throwable exception) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                coordinatorClient.compactionFailed(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), job.extent, exception.getClass().getName());
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected void updateCompactionCompleted(TExternalCompactionJob job, TCompactionStats stats) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                coordinatorClient.compactionCompleted(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), job.extent, stats);
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected TNextCompactionJob getNextJob(Supplier<UUID> uuid) throws RetryableThriftCall.RetriesExceededException {
        long startingWaitTime = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MIN_JOB_WAIT_TIME);
        long maxWaitTime = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MAX_JOB_WAIT_TIME);
        RetryableThriftCall nextJobThriftCall = new RetryableThriftCall(startingWaitTime, maxWaitTime, 0, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                ExternalCompactionId eci = ExternalCompactionId.generate((UUID)((UUID)uuid.get()));
                LOG.trace("Attempting to get next job, eci = {}", (Object)eci);
                this.currentCompactionId.set(eci);
                TNextCompactionJob tNextCompactionJob = coordinatorClient.getCompactionJob(TraceUtil.traceInfo(), this.getContext().rpcCreds(), this.queueName, ExternalCompactionUtil.getHostPortString((HostAndPort)this.compactorAddress.getAddress()), eci.toString());
                return tNextCompactionJob;
            }
            catch (Exception e) {
                this.currentCompactionId.set(null);
                throw e;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        return (TNextCompactionJob)nextJobThriftCall.run();
    }

    protected CompactionCoordinatorService.Client getCoordinatorClient() throws TTransportException {
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)this.getContext());
        if (coordinatorHost.isEmpty()) {
            throw new TTransportException("Unable to get CompactionCoordinator address from ZooKeeper");
        }
        LOG.trace("CompactionCoordinator address is: {}", coordinatorHost.orElseThrow());
        return (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)((HostAndPort)coordinatorHost.orElseThrow()), (ClientContext)this.getContext());
    }

    protected FileCompactorRunnable createCompactionJob(final TExternalCompactionJob job, final LongAdder totalInputEntries, final LongAdder totalInputBytes, final CountDownLatch started, final CountDownLatch stopped, final AtomicReference<Throwable> err) {
        return new FileCompactorRunnable(){
            private final AtomicReference<FileCompactor> compactor = new AtomicReference();
            private volatile long startTimeNanos = -1L;

            @Override
            public void initialize() throws RetryableThriftCall.RetriesExceededException {
                TableConfiguration aConfig;
                LOG.info("Starting up compaction runnable for job: {}", (Object)job);
                this.startTimeNanos = System.nanoTime();
                TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.STARTED, "Compaction started", -1L, -1L, -1L, this.getCompactionAge().toNanos());
                Compactor.this.updateCompactionState(job, update);
                KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                TableConfiguration tConfig = Compactor.this.getContext().getTableConfiguration(extent.tableId());
                if (!job.getOverrides().isEmpty()) {
                    aConfig = new ConfigurationCopy((Iterable)tConfig);
                    job.getOverrides().forEach((arg_0, arg_1) -> ((ConfigurationCopy)((ConfigurationCopy)aConfig)).set(arg_0, arg_1));
                    LOG.debug("Overriding table properties with {}", (Object)job.getOverrides());
                } else {
                    aConfig = tConfig;
                }
                TabletFile outputFile = new TabletFile(new Path(job.getOutputFile()));
                TreeMap files = new TreeMap();
                job.getFiles().forEach(arg_0 -> this.lambda$initialize$0(extent, (AccumuloConfiguration)aConfig, tConfig, files, totalInputEntries, totalInputBytes, arg_0));
                ArrayList iters = new ArrayList();
                job.getIteratorSettings().getIterators().forEach(tis -> iters.add(SystemIteratorUtil.toIteratorSetting((TIteratorSetting)tis)));
                ExtCEnv cenv = new ExtCEnv(JOB_HOLDER, Compactor.this.queueName);
                this.compactor.set(new FileCompactor(Compactor.this.getContext(), extent, files, outputFile, job.isPropagateDeletes(), (FileCompactor.CompactionEnv)cenv, iters, (AccumuloConfiguration)aConfig, tConfig.getCryptoService()));
            }

            @Override
            public AtomicReference<FileCompactor> getFileCompactor() {
                return this.compactor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Preconditions.checkState((this.compactor.get() != null ? 1 : 0) != 0, (Object)"initialize not called");
                Preconditions.checkState((boolean)Compactor.this.compactionRunning.compareAndSet(false, true));
                try {
                    LOG.trace("Starting compactor");
                    started.countDown();
                    CompactionStats stat = this.compactor.get().call();
                    TCompactionStats cs = new TCompactionStats();
                    cs.setEntriesRead(stat.getEntriesRead());
                    cs.setEntriesWritten(stat.getEntriesWritten());
                    cs.setFileSize(stat.getFileSize());
                    JOB_HOLDER.setStats(cs);
                    LOG.info("Compaction completed successfully {} ", (Object)job.getExternalCompactionId());
                    TCompactionStatusUpdate update2 = new TCompactionStatusUpdate(TCompactionState.SUCCEEDED, "Compaction completed successfully", -1L, -1L, -1L, this.getCompactionAge().toNanos());
                    Compactor.this.updateCompactionState(job, update2);
                }
                catch (FileCompactor.CompactionCanceledException cce) {
                    LOG.debug("Compaction canceled {}", (Object)job.getExternalCompactionId());
                    err.set(cce);
                }
                catch (Exception e) {
                    KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                    LOG.error("Compaction failed: id: {}, extent: {}", new Object[]{job.getExternalCompactionId(), fromThriftExtent, e});
                    err.set(e);
                }
                finally {
                    stopped.countDown();
                    Preconditions.checkState((boolean)Compactor.this.compactionRunning.compareAndSet(true, false));
                }
            }

            @Override
            public Duration getCompactionAge() {
                if (this.startTimeNanos == -1L) {
                    return Duration.ZERO;
                }
                return Duration.ofNanos(System.nanoTime() - this.startTimeNanos);
            }

            private /* synthetic */ void lambda$initialize$0(KeyExtent extent, AccumuloConfiguration aConfig, TableConfiguration tConfig, Map files, LongAdder totalInputEntries2, LongAdder totalInputBytes2, InputFile f) {
                long estEntries = f.getEntries();
                StoredTabletFile stf = new StoredTabletFile(f.getMetadataFileEntry());
                if (estEntries == 0L) {
                    estEntries = Compactor.this.estimateOverlappingEntries(extent, stf, aConfig, tConfig.getCryptoService());
                }
                files.put(stf, new DataFileValue(f.getSize(), estEntries, f.getTimestamp()));
                totalInputEntries2.add(estEntries);
                totalInputBytes2.add(f.getSize());
            }
        };
    }

    private long estimateOverlappingEntries(KeyExtent extent, StoredTabletFile file, AccumuloConfiguration tableConf, CryptoService cryptoService) {
        long l;
        block8: {
            FileOperations fileFactory = FileOperations.getInstance();
            FileSystem fs = this.getContext().getVolumeManager().getFileSystemByPath(file.getPath());
            FileSKVIterator reader = fileFactory.newReaderBuilder().forFile(file.getPathStr(), fs, fs.getConf(), cryptoService).withTableConfiguration(tableConf).dropCachesBehind().build();
            try {
                l = reader.estimateOverlappingEntries(extent);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            reader.close();
        }
        return l;
    }

    static long calculateProgressCheckTime(long numBytes) {
        return Math.max(1L, numBytes / 0xA00000L);
    }

    protected Supplier<UUID> getNextId() {
        return UUID::randomUUID;
    }

    protected long getWaitTimeBetweenCompactionChecks(int numCompactors) {
        long minWait = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MIN_JOB_WAIT_TIME);
        long sleepTime = (long)numCompactors * minWait / 3L;
        sleepTime = Math.max(minWait, sleepTime);
        sleepTime = Math.min(this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MAX_JOB_WAIT_TIME), sleepTime);
        sleepTime = (long)(0.9 * (double)sleepTime + (double)sleepTime * 0.2 * random.nextDouble());
        LOG.trace("Sleeping {}ms based on {} compactors", (Object)sleepTime, (Object)numCompactors);
        return sleepTime;
    }

    protected Collection<Tag> getServiceTags(HostAndPort clientAddress) {
        return MetricsInfo.serviceTags((String)this.getContext().getInstanceName(), (String)this.getApplicationName(), (HostAndPort)clientAddress, (String)this.queueName);
    }

    private void performFailureProcessing(ConsecutiveErrorHistory errorHistory) throws InterruptedException {
        long totalFailures = errorHistory.getTotalFailures();
        if (totalFailures > 0L) {
            LOG.warn("This Compactor has had {} consecutive failures. Failures: {}", (Object)totalFailures, (Object)errorHistory.toString());
            long failureThreshold = this.getConfiguration().getCount(Property.COMPACTOR_FAILURE_TERMINATION_THRESHOLD);
            if (failureThreshold > 0L && totalFailures >= failureThreshold) {
                LOG.error("Consecutive failures ({}) has met or exceeded failure threshold ({}), exiting...", (Object)totalFailures, (Object)failureThreshold);
                this.terminated.incrementAndGet();
                throw new InterruptedException("Consecutive failures has exceeded failure threshold, exiting...");
            }
            if (totalFailures >= (long)this.getConfiguration().getCount(Property.COMPACTOR_FAILURE_BACKOFF_THRESHOLD)) {
                long interval = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_FAILURE_BACKOFF_INTERVAL);
                if (interval > 0L) {
                    long max = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_FAILURE_BACKOFF_RESET);
                    long backoffMS = Math.min(max, interval * totalFailures);
                    LOG.warn("Not starting next compaction for {}ms due to consecutive failures. Check the log and address any issues.", (Object)backoffMS);
                    if (backoffMS == max) {
                        errorHistory.clear();
                    }
                    Thread.sleep(backoffMS);
                } else if (interval == 0L) {
                    LOG.info("This Compactor has had {} consecutive failures and failure backoff is disabled.", (Object)totalFailures);
                    errorHistory.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.compactorAddress = this.startCompactorClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the compactor client service", e1);
        }
        this.updateAdvertiseAddress(this.compactorAddress.getAddress());
        HostAndPort clientAddress = this.getAdvertiseAddress();
        try {
            this.announceExistence(clientAddress);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Error registering compactor in ZooKeeper", e);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.addMetricsProducers(new MetricsProducer[]{this});
        metricsInfo.init(this.getServiceTags(clientAddress));
        CompactionWatcher watcher = new CompactionWatcher(this.getConfiguration());
        ScheduledThreadPoolExecutor schedExecutor = this.getContext().getScheduledExecutor();
        this.startGCLogger(schedExecutor);
        this.startCancelChecker(schedExecutor, this.getConfiguration().getTimeInMillis(Property.COMPACTOR_CANCEL_CHECK_INTERVAL));
        LOG.info("Compactor started, waiting for work");
        try {
            AtomicReference<Throwable> err = new AtomicReference<Throwable>();
            while (!this.isShutdownRequested()) {
                if (Thread.currentThread().isInterrupted()) {
                    LOG.info("Server process thread has been interrupted, shutting down");
                    break;
                }
                try {
                    TExternalCompactionJob job;
                    this.updateIdleStatus(true);
                    this.currentCompactionId.set(null);
                    err.set(null);
                    JOB_HOLDER.reset();
                    this.performFailureProcessing(this.errorHistory);
                    try {
                        TNextCompactionJob next = this.getNextJob(this.getNextId());
                        job = next.getJob();
                        if (!job.isSetExternalCompactionId()) {
                            LOG.trace("No external compactions in queue {}", (Object)this.queueName);
                            UtilWaitThread.sleep((long)this.getWaitTimeBetweenCompactionChecks(next.getCompactorCount()));
                            continue;
                        }
                        if (!job.getExternalCompactionId().equals(this.currentCompactionId.get().toString())) {
                            throw new IllegalStateException("Returned eci " + job.getExternalCompactionId() + " does not match supplied eci " + String.valueOf(this.currentCompactionId.get()));
                        }
                    }
                    catch (RetryableThriftCall.RetriesExceededException e2) {
                        LOG.warn("Retries exceeded getting next job. Retrying...");
                        continue;
                    }
                    LOG.debug("Received next compaction job: {}", (Object)job);
                    LongAdder totalInputEntries = new LongAdder();
                    LongAdder totalInputBytes = new LongAdder();
                    CountDownLatch started = new CountDownLatch(1);
                    CountDownLatch stopped = new CountDownLatch(1);
                    FileCompactorRunnable fcr = this.createCompactionJob(job, totalInputEntries, totalInputBytes, started, stopped, err);
                    Thread compactionThread = Threads.createNonCriticalThread((String)("Compaction job for tablet " + job.getExtent().toString()), (Runnable)fcr);
                    JOB_HOLDER.set(job, compactionThread, fcr.getFileCompactor());
                    try {
                        this.updateIdleStatus(false);
                        fcr.initialize();
                        compactionThread.start();
                        started.await();
                        long inputEntries = totalInputEntries.sum();
                        long waitTime = Compactor.calculateProgressCheckTime(totalInputBytes.sum());
                        LOG.debug("Progress checks will occur every {} seconds", (Object)waitTime);
                        String percentComplete = "unknown";
                        while (!stopped.await(waitTime, TimeUnit.SECONDS)) {
                            List running = FileCompactor.getRunningCompactions();
                            if (!running.isEmpty()) {
                                CompactionInfo info = (CompactionInfo)running.get(0);
                                if (info == null) continue;
                                long entriesRead = info.getEntriesRead();
                                long entriesWritten = info.getEntriesWritten();
                                if (inputEntries > 0L) {
                                    percentComplete = Float.toString((float)entriesRead / (float)inputEntries * 100.0f);
                                }
                                String message = String.format("Compaction in progress, read %d of %d input entries ( %s %s ), written %d entries", entriesRead, inputEntries, percentComplete, "%", entriesWritten);
                                watcher.run();
                                try {
                                    LOG.debug("Updating coordinator with compaction progress: {}.", (Object)message);
                                    TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.IN_PROGRESS, message, inputEntries, entriesRead, entriesWritten, fcr.getCompactionAge().toNanos());
                                    this.updateCompactionState(job, update);
                                }
                                catch (RetryableThriftCall.RetriesExceededException e) {
                                    LOG.warn("Error updating coordinator with compaction progress, error: {}", (Object)e.getMessage());
                                }
                                continue;
                            }
                            LOG.debug("Waiting on compaction thread to finish, but no RUNNING compaction");
                        }
                        compactionThread.join();
                        LOG.trace("Compaction thread finished.");
                        watcher.run();
                        if (err.get() != null) {
                            this.checkIfCanceled();
                        }
                        if (compactionThread.isInterrupted() || JOB_HOLDER.isCancelled() || err.get() != null && err.get().getClass().equals(InterruptedException.class)) {
                            LOG.warn("Compaction thread was interrupted, sending CANCELLED state");
                            try {
                                TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.CANCELLED, "Compaction cancelled", -1L, -1L, -1L, fcr.getCompactionAge().toNanos());
                                this.updateCompactionState(job, update);
                                this.updateCompactionFailed(job, null);
                                this.cancelled.incrementAndGet();
                                this.currentCompactionId.set(null);
                            }
                            catch (RetryableThriftCall.RetriesExceededException e) {
                                try {
                                    LOG.error("Error updating coordinator with compaction cancellation.", (Throwable)e);
                                    this.currentCompactionId.set(null);
                                }
                                catch (Throwable throwable) {
                                    this.currentCompactionId.set(null);
                                    throw throwable;
                                }
                            }
                        }
                        if (err.get() != null) {
                            KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                            try {
                                LOG.info("Updating coordinator with compaction failure: id: {}, extent: {}", (Object)job.getExternalCompactionId(), (Object)fromThriftExtent);
                                TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.FAILED, "Compaction failed due to: " + err.get().getMessage(), -1L, -1L, -1L, fcr.getCompactionAge().toNanos());
                                this.updateCompactionState(job, update);
                                this.updateCompactionFailed(job, err.get());
                                this.failed.incrementAndGet();
                                this.errorHistory.addError(fromThriftExtent.tableId(), err.get());
                                this.currentCompactionId.set(null);
                            }
                            catch (RetryableThriftCall.RetriesExceededException e) {
                                try {
                                    LOG.error("Error updating coordinator with compaction failure: id: {}, extent: {}", new Object[]{job.getExternalCompactionId(), fromThriftExtent, e});
                                    this.currentCompactionId.set(null);
                                }
                                catch (Throwable throwable) {
                                    this.currentCompactionId.set(null);
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            LOG.trace("Updating coordinator with compaction completion.");
                            this.updateCompactionCompleted(job, JOB_HOLDER.getStats());
                            this.completed.incrementAndGet();
                            this.errorHistory.clear();
                            this.currentCompactionId.set(null);
                        }
                        catch (RetryableThriftCall.RetriesExceededException e) {
                            try {
                                LOG.error("Error updating coordinator with compaction completion, cancelling compaction.", (Throwable)e);
                                try {
                                    this.cancel(job.getExternalCompactionId());
                                }
                                catch (TException e1) {
                                    LOG.error("Error cancelling compaction.", (Throwable)e1);
                                }
                                this.currentCompactionId.set(null);
                            }
                            catch (Throwable throwable) {
                                this.currentCompactionId.set(null);
                                throw throwable;
                            }
                        }
                    }
                    catch (RuntimeException e1) {
                        LOG.error("Compactor thread was interrupted waiting for compaction to start, cancelling job", (Throwable)e1);
                        try {
                            this.cancel(job.getExternalCompactionId());
                        }
                        catch (TException e2) {
                            LOG.error("Error cancelling compaction.", (Throwable)e2);
                        }
                    }
                    finally {
                        this.currentCompactionId.set(null);
                        this.updateIdleStatus(true);
                        while (compactionThread.isAlive()) {
                            compactionThread.interrupt();
                            compactionThread.join(1000L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupt Exception received, shutting down");
                    this.gracefulShutdown(this.getContext().rpcCreds());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred in Compactor", (Throwable)e);
        }
        finally {
            LOG.debug("Stopping Thrift Servers");
            if (this.compactorAddress.server != null) {
                this.compactorAddress.server.stop();
            }
            try {
                LOG.debug("Closing filesystems");
                VolumeManager mgr = this.getContext().getVolumeManager();
                if (null != mgr) {
                    mgr.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close filesystem : {}", (Object)e.getMessage(), (Object)e);
            }
            this.gcLogger.logGCInfo(this.getConfiguration());
            super.close();
            this.getShutdownComplete().set(true);
            LOG.info("stop requested. exiting ... ");
            try {
                if (null != this.compactorLock) {
                    this.compactorLock.unlock();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to release compactor lock", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try (Compactor compactor = new Compactor(new CompactorServerOpts(), args);){
            compactor.runServer();
        }
    }

    public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        List compactions = FileCompactor.getRunningCompactions();
        ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
        for (CompactionInfo compactionInfo : compactions) {
            ret.add(compactionInfo.toThrift());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TExternalCompactionJob getRunningCompaction(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionJob job = null;
        CompactionJobHolder compactionJobHolder = JOB_HOLDER;
        synchronized (compactionJobHolder) {
            job = JOB_HOLDER.getJob();
        }
        if (null == job) {
            return new TExternalCompactionJob();
        }
        return job;
    }

    public String getRunningCompactionId(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExternalCompactionId eci = this.currentCompactionId.get();
        if (null == eci) {
            return "";
        }
        return eci.canonical();
    }

    public ServiceLock getLock() {
        return this.compactorLock;
    }

    private static class ConsecutiveErrorHistory
    extends HashMap<TableId, HashMap<String, AtomicLong>> {
        private static final long serialVersionUID = 1L;

        private ConsecutiveErrorHistory() {
        }

        public long getTotalFailures() {
            long total = 0L;
            for (TableId tid : this.keySet()) {
                total += this.getTotalTableFailures(tid);
            }
            return total;
        }

        public long getTotalTableFailures(TableId tid) {
            long total = 0L;
            for (AtomicLong failures : ((HashMap)this.get(tid)).values()) {
                total += failures.get();
            }
            return total;
        }

        public void addError(TableId tid, Throwable error) {
            this.computeIfAbsent(tid, t -> new HashMap()).computeIfAbsent(error.toString(), e -> new AtomicLong(0L)).incrementAndGet();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (TableId tid : this.keySet()) {
                buf.append("\nTable: ").append(tid);
                for (Map.Entry error : ((HashMap)this.get(tid)).entrySet()) {
                    buf.append("\n\tException: ").append((String)error.getKey()).append(", count: ").append(((AtomicLong)error.getValue()).get());
                }
            }
            return buf.toString();
        }
    }

    public static class CompactorServerOpts
    extends ServerOpts {
        @Parameter(required=true, names={"-q", "--queue"}, description="compaction queue name")
        private String queueName = null;

        public String getQueueName() {
            return this.queueName;
        }
    }

    public static interface FileCompactorRunnable
    extends Runnable {
        public void initialize() throws RetryableThriftCall.RetriesExceededException;

        public AtomicReference<FileCompactor> getFileCompactor();

        public Duration getCompactionAge();
    }
}

