<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

Accumulo Stress Test
====================

This is an attempt to observe the behavior Accumulo displays when compacting and
reading cells. There are two components to this package:
`org.apache.accumulo.test.stress.random.Write` and
`org.apache.accumulo.test.stress.random.Scan`.

Since this test is meant to stress the system, there is no pre-defined test
period and no success criteria that we can programmatically check. During a
successful test period, the Accumulo cluster should remain stable and
functional. Possible failure conditions include component failures, such as
tablet servers running out of memory.

The `org.apache.accumulo.test.stress.random.Write` utility provides facilities
for writing random sized cells. Users can configure minimum and maximum sized
portions of a cell. The portions users can configure are the row, column family,
column qualifier and value. Note that the sizes are uniformly distributed
between the minimum and maximum values.

The `org.apache.accumulo.test.stress.random.Scan` utility provides users with
the ability to query tables generated by the Write. It will pick a tablet at
random and scan the entire range. The amount of times this process is performed
is user configurable. By default, it happens 1,024 times. Users can also specify
whether or not the scan should be isolated.

There is no shared state intended by either of these services. This allows
multiple clients to be run in parallel, either on the same host or distributed
across hosts.

## Prerequisites

The utilities are run on a normal, initialized Accumulo cluster. By default,
they only work with a table named "stress_test".

The start and stop scripts rely on pssh. Before running them, you will need
to install pssh on the machines that will be controlled by them.

## Running

Copy `stress-env.sh.example` to `stress-env.sh` and edit it, supplying at least
correct values for the USERPASS and INSTANCE variables. The remainder of this
file describes and provides defaults for many of the configuration options
for the stress utilities.

### Individual Execution

Before starting a fresh write test, clear out the test table using the Accumulo
shell.

    > deletetable -f stress_test
    > createtable stress_test

To run a writer:

    $ ./writer.sh

The writer will begin logging into a "logs" subdirectory, using timestamped
filenames. You can stop the writer by killing it or using Control-C.

To run a reader:

    $ ./reader.sh

The reader logs like the writer. By default, the reader reads forever, but
it can be configured for a fixed number of scan iterations.

### Group Execution

To run writers across multiple machines, create a writers file and list each
host that will run a writer, one per line.

Finally, to start and stop the writers:

    $ ./start-writers.sh
    $ ./stop-writers.sh

For readers, make a similar readers file, and use `start-readers.sh` and
`stop-readers.sh`.

The start scripts copy out stress-env.sh to each of the writers and readers,
overwriting what is there, so you only need to edit the file on the host from
which you run those scripts.

Note that in versions of Accumulo greater than 1.6.0, users should verify that
the cell sizes they supply meet the criteria set forth by the key constraints
on their tables. By default, tables are configured to reject keys that are
greater than 1MB.
