/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.examples.simple.filedata.ChunkInputStream;
import org.apache.accumulo.examples.simple.filedata.FileDataIngest;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ChunkInputFormat
extends InputFormatBase<List<Map.Entry<Key, Value>>, InputStream> {
    public RecordReader<List<Map.Entry<Key, Value>>, InputStream> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new InputFormatBase.RecordReaderBase<List<Map.Entry<Key, Value>>, InputStream>(){
            private PeekingIterator<Map.Entry<Key, Value>> peekingScannerIterator;

            public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
                super.initialize(inSplit, attempt);
                this.peekingScannerIterator = new PeekingIterator(this.scannerIterator);
                this.currentK = new ArrayList();
                this.currentV = new ChunkInputStream();
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                ((List)this.currentK).clear();
                if (this.peekingScannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.peekingScannerIterator.peek();
                    while (!((Key)entry.getKey()).getColumnFamily().equals((Object)FileDataIngest.CHUNK_CF)) {
                        ((List)this.currentK).add(entry);
                        this.peekingScannerIterator.next();
                        if (!this.peekingScannerIterator.hasNext()) {
                            return true;
                        }
                        entry = (Map.Entry)this.peekingScannerIterator.peek();
                    }
                    this.currentKey = (Key)entry.getKey();
                    ((ChunkInputStream)this.currentV).setSource(this.peekingScannerIterator);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true)));
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

