/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.examples.simple.filedata.FileDataIngest;
import org.apache.accumulo.examples.simple.filedata.VisibilityCombiner;
import org.apache.hadoop.io.Text;

public class ChunkCombiner
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source;
    private SortedKeyValueIterator<Key, Value> refsSource;
    private static final Collection<ByteSequence> refsColf = Collections.singleton(FileDataIngest.REFS_CF_BS);
    private Map<Text, byte[]> lastRowVC = Collections.emptyMap();
    private Key topKey = null;
    private Value topValue = null;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
        this.refsSource = source.deepCopy(env);
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public void next() throws IOException {
        this.findTop();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.findTop();
    }

    private void findTop() throws IOException {
        do {
            this.topKey = null;
            this.topValue = null;
        } while (this.source.hasTop() && this._findTop() == null);
    }

    private byte[] _findTop() throws IOException {
        this.topKey = new Key((Key)this.source.getTopKey());
        this.topValue = new Value((Value)this.source.getTopValue());
        this.source.next();
        if (!this.topKey.getColumnFamilyData().equals((Object)FileDataIngest.CHUNK_CF_BS)) {
            return this.topKey.getColumnVisibility().getBytes();
        }
        long maxTS = this.topKey.getTimestamp();
        while (this.source.hasTop() && ((Key)this.source.getTopKey()).equals(this.topKey, PartialKey.ROW_COLFAM_COLQUAL)) {
            if (((Key)this.source.getTopKey()).getTimestamp() > maxTS) {
                maxTS = ((Key)this.source.getTopKey()).getTimestamp();
            }
            if (!this.topValue.equals((Object)this.source.getTopValue())) {
                throw new RuntimeException("values not equals " + this.topKey + " " + this.source.getTopKey() + " : " + this.diffInfo(this.topValue, (Value)this.source.getTopValue()));
            }
            this.source.next();
        }
        byte[] vis = this.getVisFromRefs();
        if (vis != null) {
            this.topKey = new Key(this.topKey.getRowData().toArray(), this.topKey.getColumnFamilyData().toArray(), this.topKey.getColumnQualifierData().toArray(), vis, maxTS);
        }
        return vis;
    }

    private byte[] getVisFromRefs() throws IOException {
        Text row = this.topKey.getRow();
        if (this.lastRowVC.containsKey(row)) {
            return this.lastRowVC.get(row);
        }
        Range range = new Range(row);
        this.refsSource.seek(range, refsColf, true);
        VisibilityCombiner vc = null;
        while (this.refsSource.hasTop()) {
            if (vc == null) {
                vc = new VisibilityCombiner();
            }
            vc.add(((Key)this.refsSource.getTopKey()).getColumnVisibilityData());
            this.refsSource.next();
        }
        if (vc == null) {
            this.lastRowVC = Collections.singletonMap(row, null);
            return null;
        }
        this.lastRowVC = Collections.singletonMap(row, vc.get());
        return vc.get();
    }

    private String diffInfo(Value v1, Value v2) {
        if (v1.getSize() != v2.getSize()) {
            return "val len not equal " + v1.getSize() + "!=" + v2.getSize();
        }
        byte[] vb1 = v1.get();
        byte[] vb2 = v2.get();
        for (int i = 0; i < vb1.length; ++i) {
            if (vb1[i] == vb2[i]) continue;
            return String.format("first diff at offset %,d 0x%02x != 0x%02x", i, 0xFF & vb1[i], 0xFF & vb2[i]);
        }
        return null;
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        ChunkCombiner cc = new ChunkCombiner();
        try {
            cc.init((SortedKeyValueIterator<Key, Value>)this.source.deepCopy(env), null, env);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return cc;
    }
}

