/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.stress.random;

import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.test.stress.random.RandomByteArrays;
import org.apache.accumulo.test.stress.random.RandomWithinRange;
import org.apache.accumulo.test.stress.random.Stream;

public class RandomMutations
extends Stream<Mutation> {
    private final RandomByteArrays rows;
    private final RandomByteArrays column_families;
    private final RandomByteArrays column_qualifiers;
    private final RandomByteArrays values;
    private final RandomWithinRange row_widths;
    private final int max_cells_per_mutation;
    private byte[] current_row;
    private int cells_remaining_in_row;

    public RandomMutations(RandomByteArrays rows, RandomByteArrays column_families, RandomByteArrays column_qualifiers, RandomByteArrays values, RandomWithinRange row_widths, int max_cells_per_mutation) {
        this.rows = rows;
        this.column_families = column_families;
        this.column_qualifiers = column_qualifiers;
        this.values = values;
        this.row_widths = row_widths;
        this.max_cells_per_mutation = max_cells_per_mutation > 0 ? max_cells_per_mutation : Integer.MAX_VALUE;
        this.current_row = null;
        this.cells_remaining_in_row = 0;
    }

    @Override
    public Mutation next() {
        if (this.cells_remaining_in_row == 0) {
            this.current_row = this.rows.next();
            this.cells_remaining_in_row = this.row_widths.next();
        }
        Mutation m = new Mutation(this.current_row);
        int cells = Math.min(this.cells_remaining_in_row, this.max_cells_per_mutation);
        for (int i = 1; i <= cells; ++i) {
            m.put(this.column_families.next(), this.column_qualifiers.next(), this.values.next());
        }
        this.cells_remaining_in_row -= cells;
        return m;
    }
}

