/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.server.security;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.Assert;
import org.junit.Test;

public class SystemCredentialsIT
extends ConfigurableMacBase {
    private static final int FAIL_CODE = 7;
    private static final int BAD_PASSWD_FAIL_CODE = 8;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testSystemCredentials() throws Exception {
        Assert.assertEquals((long)0L, (long)this.exec(SystemCredentialsIT.class, "good", this.getCluster().getZooKeepers()).waitFor());
        Assert.assertEquals((long)7L, (long)this.exec(SystemCredentialsIT.class, "bad", this.getCluster().getZooKeepers()).waitFor());
        Assert.assertEquals((long)8L, (long)this.exec(SystemCredentialsIT.class, "bad_password", this.getCluster().getZooKeepers()).waitFor());
    }

    public static void main(String[] args) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        block12: {
            Connector conn;
            Object inst;
            SystemCredentials creds = null;
            if (args.length < 2) {
                throw new RuntimeException("Incorrect usage; expected to be run by test only");
            }
            if (args[0].equals("bad")) {
                inst = new Instance(){

                    @Deprecated
                    public void setConfiguration(AccumuloConfiguration conf) {
                        throw new UnsupportedOperationException();
                    }

                    public int getZooKeepersSessionTimeOut() {
                        throw new UnsupportedOperationException();
                    }

                    public String getZooKeepers() {
                        throw new UnsupportedOperationException();
                    }

                    public String getRootTabletLocation() {
                        throw new UnsupportedOperationException();
                    }

                    public List<String> getMasterLocations() {
                        throw new UnsupportedOperationException();
                    }

                    public String getInstanceName() {
                        throw new UnsupportedOperationException();
                    }

                    public String getInstanceID() {
                        return SystemCredentials.class.getName();
                    }

                    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, byte[] pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public AccumuloConfiguration getConfiguration() {
                        throw new UnsupportedOperationException();
                    }
                };
                creds = SystemCredentials.get((Instance)inst);
            } else if (args[0].equals("good")) {
                creds = SystemCredentials.get((Instance)HdfsZooInstance.getInstance());
            } else if (args[0].equals("bad_password")) {
                inst = new Instance(){

                    public int getZooKeepersSessionTimeOut() {
                        throw new UnsupportedOperationException();
                    }

                    public String getZooKeepers() {
                        throw new UnsupportedOperationException();
                    }

                    public String getRootTabletLocation() {
                        throw new UnsupportedOperationException();
                    }

                    public List<String> getMasterLocations() {
                        throw new UnsupportedOperationException();
                    }

                    public String getInstanceName() {
                        throw new UnsupportedOperationException();
                    }

                    public String getInstanceID() {
                        return SystemCredentials.class.getName();
                    }

                    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public Connector getConnector(String user, byte[] pass) throws AccumuloException, AccumuloSecurityException {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public AccumuloConfiguration getConfiguration() {
                        throw new UnsupportedOperationException();
                    }

                    @Deprecated
                    public void setConfiguration(AccumuloConfiguration conf) {
                        throw new UnsupportedOperationException();
                    }
                };
                creds = new SystemCredentials(inst, "!SYSTEM", (AuthenticationToken)new PasswordToken((CharSequence)"fake"));
            } else {
                throw new RuntimeException("Incorrect usage; expected to be run by test only");
            }
            Instance instance = HdfsZooInstance.getInstance();
            try {
                conn = instance.getConnector(creds.getPrincipal(), creds.getToken());
            }
            catch (AccumuloSecurityException e) {
                e.printStackTrace(System.err);
                System.exit(8);
                return;
            }
            try {
                Scanner scan = conn.createScanner("accumulo.root", Authorizations.EMPTY);
                for (Map.Entry e : scan) {
                    e.hashCode();
                }
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof AccumuloSecurityException) || ((AccumuloSecurityException)e.getCause()).getSecurityErrorCode() != SecurityErrorCode.BAD_CREDENTIALS) break block12;
                e.printStackTrace(System.err);
                System.exit(7);
            }
        }
    }
}

