/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.replication.MockReplicaSystem;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class UnusedWalDoesntCloseReplicationStatusIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setNumTservers(1);
    }

    @Test
    public void test() throws Exception {
        File accumuloDir = this.getCluster().getConfig().getAccumuloDir();
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.securityOperations().grantTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        int numericTableId = Integer.parseInt(tableId);
        int fakeTableId = numericTableId + 1;
        Assert.assertNotNull((String)"Did not find table ID", (Object)tableId);
        conn.tableOperations().setProperty(tableName, Property.TABLE_REPLICATION.getKey(), "true");
        conn.tableOperations().setProperty(tableName, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        conn.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"50000"));
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        File tserverWalDir = new File(accumuloDir, "wal/faketserver+port");
        File tserverWal = new File(tserverWalDir, UUID.randomUUID().toString());
        fs.mkdirs(new Path(tserverWalDir.getAbsolutePath()));
        FSDataOutputStream out = fs.create(new Path(tserverWal.getAbsolutePath()));
        out.write("--- Log File Header (v3) ---".getBytes(StandardCharsets.UTF_8));
        DataOutputStream dos = new DataOutputStream((OutputStream)out);
        dos.writeUTF("NullCryptoModule");
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        key.event = LogEvents.OPEN;
        key.tserverSession = tserverWal.getAbsolutePath();
        key.filename = tserverWal.getAbsolutePath();
        key.write((DataOutput)out);
        value.write((DataOutput)out);
        key.event = LogEvents.DEFINE_TABLET;
        key.tablet = new KeyExtent(Integer.toString(fakeTableId), null, null);
        key.seq = 1L;
        key.tabletId = 1;
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.tablet = null;
        key.event = LogEvents.MUTATION;
        key.filename = tserverWal.getAbsolutePath();
        value.mutations = Arrays.asList(new ServerMutation(new Text("row")));
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.event = LogEvents.COMPACTION_START;
        key.filename = accumuloDir.getAbsolutePath() + "/tables/" + fakeTableId + "/t-000001/A000001.rf";
        value.mutations = Collections.emptyList();
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.event = LogEvents.COMPACTION_FINISH;
        value.mutations = Collections.emptyList();
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        dos.close();
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"m");
        m.put((CharSequence)"m", (CharSequence)"m", (CharSequence)"M");
        bw.addMutation(m);
        bw.close();
        log.info("State of metadata table after inserting a record");
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        for (Map.Entry entry : s) {
            System.out.println(((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue());
        }
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        for (Map.Entry entry : s) {
            System.out.println(((Key)entry.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
        }
        log.info("Offline'ing table");
        conn.tableOperations().offline(tableName, true);
        String walUri = tserverWal.toURI().toString();
        KeyExtent extent = new KeyExtent(tableId, null, null);
        bw = conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation(extent.getMetadataEntry());
        m.put(MetadataSchema.TabletsSection.LogColumnFamily.NAME, new Text("localhost:12345/" + walUri), new Value((walUri + "|1").getBytes(StandardCharsets.UTF_8)));
        bw.addMutation(m);
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + new Path(walUri).toString()));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId), new Value(StatusUtil.fileCreated((long)System.currentTimeMillis()).toByteArray()));
        bw.addMutation(m);
        bw.close();
        log.info("State of metadata after injecting WAL manually");
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        for (Map.Entry entry : s) {
            log.info(((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue());
        }
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        for (Map.Entry entry : s) {
            log.info(((Key)entry.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
        }
        log.info("Bringing table online");
        conn.tableOperations().online(tableName, true);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)conn.createScanner(tableName, Authorizations.EMPTY)));
        log.info("Table has performed recovery, state of metadata:");
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        for (Map.Entry entry : s) {
            log.info(((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue());
        }
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        for (Map.Entry entry : s) {
            Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            log.info(((Key)entry.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessage)status));
            Assert.assertFalse((String)"Status record was closed and it should not be", (boolean)status.getClosed());
        }
    }
}

