/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.image;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.image.Write;
import org.apache.hadoop.io.Text;

public class ImageFixture
extends Fixture {
    String imageTableName;
    String indexTableName;

    @Override
    public void setUp(State state, Environment env) throws Exception {
        Connector conn = env.getConnector();
        Instance instance = env.getInstance();
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 256; ++i) {
            splits.add(new Text(String.format("%04x", i << 8)));
        }
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        String pid = env.getPid();
        this.imageTableName = String.format("img_%s_%s_%d", hostname, pid, System.currentTimeMillis());
        state.set("imageTableName", this.imageTableName);
        this.indexTableName = String.format("img_ndx_%s_%s_%d", hostname, pid, System.currentTimeMillis());
        state.set("indexTableName", this.indexTableName);
        try {
            conn.tableOperations().create(this.imageTableName);
            conn.tableOperations().addSplits(this.imageTableName, splits);
            this.log.debug((Object)("Created table " + this.imageTableName + " (id:" + (String)Tables.getNameToIdMap((Instance)instance).get(this.imageTableName) + ")"));
        }
        catch (TableExistsException e) {
            this.log.error((Object)("Table " + this.imageTableName + " already exists."));
            throw e;
        }
        try {
            conn.tableOperations().create(this.indexTableName);
            this.log.debug((Object)("Created table " + this.indexTableName + " (id:" + (String)Tables.getNameToIdMap((Instance)instance).get(this.indexTableName) + ")"));
        }
        catch (TableExistsException e) {
            this.log.error((Object)("Table " + this.imageTableName + " already exists."));
            throw e;
        }
        Random rand = new Random();
        if (rand.nextInt(10) < 5) {
            Map<String, Set<Text>> groups = ImageFixture.getLocalityGroups();
            conn.tableOperations().setLocalityGroups(this.imageTableName, groups);
            this.log.debug((Object)("Configured locality groups for " + this.imageTableName + " groups = " + groups));
        }
        state.set("numWrites", 0L);
        state.set("totalWrites", 0L);
        state.set("verified", 0);
        state.set("lastIndexRow", new Text(""));
    }

    static Map<String, Set<Text>> getLocalityGroups() {
        HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
        HashSet<Text> lg1 = new HashSet<Text>();
        lg1.add(Write.CONTENT_COLUMN_FAMILY);
        groups.put("lg1", lg1);
        HashSet<Text> lg2 = new HashSet<Text>();
        lg2.add(Write.META_COLUMN_FAMILY);
        groups.put("lg2", lg2);
        return groups;
    }

    @Override
    public void tearDown(State state, Environment env) throws Exception {
        if (env.isMultiTableBatchWriterInitialized()) {
            MultiTableBatchWriter mtbw = env.getMultiTableBatchWriter();
            try {
                mtbw.close();
            }
            catch (MutationsRejectedException e) {
                this.log.error((Object)"Ignoring mutations that weren't flushed", (Throwable)e);
            }
            env.resetMultiTableBatchWriter();
        }
        this.log.debug((Object)("Dropping tables: " + this.imageTableName + " " + this.indexTableName));
        Connector conn = env.getConnector();
        conn.tableOperations().delete(this.imageTableName);
        conn.tableOperations().delete(this.indexTableName);
        this.log.debug((Object)("Final total of writes: " + state.getLong("totalWrites")));
    }
}

