/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.conditional;

import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.ColumnSliceFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.conditional.Utils;

public class Verify
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String table = state.getString("tableName");
        Connector conn = env.getConnector();
        int numAccts = (Integer)state.get("numAccts");
        for (int i = 0; i < (Integer)state.get("numBanks"); ++i) {
            this.verifyBank(table, conn, Utils.getBank(i), numAccts);
        }
    }

    private void verifyBank(String table, Connector conn, String row, int numAccts) throws TableNotFoundException, Exception {
        this.log.debug((Object)("Verifying bank " + row));
        int count = 0;
        int sum = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        try (IsolatedScanner scanner = new IsolatedScanner(conn.createScanner(table, Authorizations.EMPTY));){
            scanner.setRange(new Range((CharSequence)row));
            IteratorSetting iterConf = new IteratorSetting(100, "cqsl", ColumnSliceFilter.class);
            ColumnSliceFilter.setSlice((IteratorSetting)iterConf, (String)"bal", (boolean)true, (String)"bal", (boolean)true);
            scanner.clearScanIterators();
            scanner.addScanIterator(iterConf);
            for (Map.Entry entry : scanner) {
                int bal = Integer.parseInt(((Value)entry.getValue()).toString());
                sum += bal;
                if (bal > max) {
                    max = bal;
                }
                if (bal < min) {
                    min = bal;
                }
                ++count;
            }
        }
        if (count > 0 && sum != numAccts * 100) {
            throw new Exception("Sum is off " + sum);
        }
        this.log.debug((Object)("Verified " + row + " count = " + count + " sum = " + sum + " min = " + min + " max = " + max));
    }
}

