/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class ScanTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
            Iterator iter = scanner.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            this.log.debug((Object)("Scanned " + tableName));
        }
        catch (TableDeletedException e) {
            this.log.debug((Object)("Scan " + tableName + " failed, table deleted"));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("Scan " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException e) {
            this.log.debug((Object)("Scan " + tableName + " failed, offline"));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof AccumuloSecurityException) {
                this.log.debug((Object)("BatchScan " + tableName + " failed, permission error"));
            }
            throw e;
        }
    }
}

