/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class IsolatedScan
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            RowIterator iter = new RowIterator((Iterable)new IsolatedScanner(conn.createScanner(tableName, Authorizations.EMPTY)));
            while (iter.hasNext()) {
                PeekingIterator row = new PeekingIterator(iter.next());
                Map.Entry kv = null;
                if (row.hasNext()) {
                    kv = (Map.Entry)row.peek();
                }
                while (row.hasNext()) {
                    Map.Entry currentKV = (Map.Entry)row.next();
                    if (((Value)kv.getValue()).equals(currentKV.getValue())) continue;
                    throw new Exception("values not equal " + kv + " " + currentKV);
                }
            }
            this.log.debug((Object)("Isolated scan " + tableName));
        }
        catch (TableDeletedException e) {
            this.log.debug((Object)("Isolated scan " + tableName + " failed, table deleted"));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("Isolated scan " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException e) {
            this.log.debug((Object)("Isolated scan " + tableName + " failed, offline"));
        }
    }
}

