/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.BlockFileWriter;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.file.streams.PositionedOutputs;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BulkImport
extends Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String bulkDir = "/tmp/concurrent_bulk/b_" + String.format("%016x", rand.nextLong() & Long.MAX_VALUE);
        fs.mkdirs(new Path(bulkDir));
        fs.mkdirs(new Path(bulkDir + "_f"));
        try {
            try (RFileBatchWriter bw = new RFileBatchWriter(conf, fs, bulkDir + "/file01.rf");){
                TreeSet<Long> rows = new TreeSet<Long>();
                int numRows = rand.nextInt(100000);
                for (int i = 0; i < numRows; ++i) {
                    rows.add(rand.nextLong() & Long.MAX_VALUE);
                }
                for (Long row : rows) {
                    Mutation m = new Mutation((CharSequence)String.format("%016x", row));
                    long val = rand.nextLong() & Long.MAX_VALUE;
                    for (int j = 0; j < 10; ++j) {
                        m.put((CharSequence)"cf", (CharSequence)("cq" + j), new Value(String.format("%016x", val).getBytes(StandardCharsets.UTF_8)));
                    }
                    bw.addMutation(m);
                }
            }
            conn.tableOperations().importDirectory(tableName, bulkDir, bulkDir + "_f", rand.nextBoolean());
            this.log.debug((Object)("BulkImported to " + tableName));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("BulkImport " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException toe) {
            this.log.debug((Object)("BulkImport " + tableName + " failed, offline"));
        }
        finally {
            fs.delete(new Path(bulkDir), true);
            fs.delete(new Path(bulkDir + "_f"), true);
        }
    }

    public static class RFileBatchWriter
    implements BatchWriter {
        RFile.Writer writer;

        public RFileBatchWriter(Configuration conf, FileSystem fs, String file) throws IOException {
            DefaultConfiguration aconf = AccumuloConfiguration.getDefaultConfiguration();
            CachableBlockFile.Writer cbw = new CachableBlockFile.Writer((OutputStream)PositionedOutputs.wrap((OutputStream)fs.create(new Path(file), false, conf.getInt("io.file.buffer.size", 4096), (short)conf.getInt("dfs.replication", 3), conf.getLong("dfs.block.size", 0x4000000L))), "gz", conf, (AccumuloConfiguration)aconf);
            this.writer = new RFile.Writer((BlockFileWriter)cbw, 100000);
            this.writer.startDefaultLocalityGroup();
        }

        public void addMutation(Mutation m) throws MutationsRejectedException {
            List updates = m.getUpdates();
            for (ColumnUpdate cu : updates) {
                Key key = new Key(m.getRow(), cu.getColumnFamily(), cu.getColumnQualifier(), cu.getColumnVisibility(), 42L, false, false);
                Value val = new Value(cu.getValue(), false);
                try {
                    this.writer.append(key, val);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
            for (Mutation mutation : iterable) {
                this.addMutation(mutation);
            }
        }

        public void flush() throws MutationsRejectedException {
        }

        public void close() throws MutationsRejectedException {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

