/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.Properties;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.bulk.BulkMinusOne;
import org.apache.accumulo.test.randomwalk.bulk.BulkPlusOne;
import org.apache.accumulo.test.randomwalk.bulk.BulkTest;
import org.apache.accumulo.test.randomwalk.bulk.SelectiveQueueing;

public abstract class BulkImportTest
extends BulkTest {
    public static final String SKIPPED_IMPORT = "skipped.import";
    public static final String TRUE = Boolean.TRUE.toString();
    public static final String FALSE = Boolean.FALSE.toString();

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String lastImportSkipped = state.getString(SKIPPED_IMPORT);
        if (null != lastImportSkipped) {
            if (!this.getClass().equals(BulkMinusOne.class)) {
                throw new IllegalStateException("Should not have a skipped import marker for a class other than " + BulkMinusOne.class.getName() + " but was " + this.getClass().getName());
            }
            if (TRUE.equals(lastImportSkipped)) {
                this.log.debug((Object)"Last import was skipped, skipping this import to ensure consistency");
                state.remove(SKIPPED_IMPORT);
                this.log.debug((Object)"Waiting 30s before continuing");
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            state.remove(SKIPPED_IMPORT);
        }
        if (this.shouldQueueMoreImports(state, env)) {
            super.visit(state, env, props);
        } else {
            this.log.debug((Object)"Not queuing more imports this round because too many are already queued");
            state.set(SKIPPED_IMPORT, TRUE);
        }
    }

    private boolean shouldQueueMoreImports(State state, Environment env) throws Exception {
        if (this.getClass().equals(BulkPlusOne.class)) {
            return SelectiveQueueing.shouldQueueOperation(state, env);
        }
        return true;
    }
}

