/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import com.google.common.collect.Iterators;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.AccumuloProxy;
import org.apache.accumulo.proxy.thrift.Column;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.Condition;
import org.apache.accumulo.proxy.thrift.ConditionalStatus;
import org.apache.accumulo.proxy.thrift.ConditionalUpdates;
import org.apache.accumulo.proxy.thrift.ConditionalWriterOptions;
import org.apache.accumulo.proxy.thrift.Durability;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.proxy.thrift.WriterOptions;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.Assert;
import org.junit.Test;

public class ProxyDurabilityIT
extends ConfigurableMacBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
    }

    private static ByteBuffer bytes(String value) {
        return ByteBuffer.wrap(value.getBytes());
    }

    @Test
    public void testDurability() throws Exception {
        Connector c = this.getConnector();
        Properties props = new Properties();
        File emptyFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        emptyFile.deleteOnExit();
        props.put("instance", c.getInstance().getInstanceName());
        props.put("zookeepers", c.getInstance().getZooKeepers());
        props.put("tokenClass", PasswordToken.class.getName());
        props.put("clientConfigurationFile", emptyFile.toString());
        TJSONProtocol.Factory protocol = new TJSONProtocol.Factory();
        int proxyPort = PortUtils.getRandomFreePort();
        TServer proxyServer = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)proxyPort), (TProtocolFactory)protocol, (Properties)props).server;
        while (!proxyServer.isServing()) {
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        AccumuloProxy.Client client = new TestProxyClient("localhost", proxyPort, (TProtocolFactory)protocol).proxy();
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("password", "testRootPassword1");
        ByteBuffer login = client.login("root", properties);
        String tableName = this.getUniqueNames(1)[0];
        client.createTable(login, tableName, true, TimeType.MILLIS);
        Assert.assertTrue((boolean)c.tableOperations().exists(tableName));
        WriterOptions options = new WriterOptions();
        options.setDurability(Durability.NONE);
        String writer = client.createWriter(login, tableName, options);
        TreeMap<ByteBuffer, List<ColumnUpdate>> cells = new TreeMap<ByteBuffer, List<ColumnUpdate>>();
        ColumnUpdate column = new ColumnUpdate(ProxyDurabilityIT.bytes("cf"), ProxyDurabilityIT.bytes("cq"));
        column.setValue("value".getBytes());
        cells.put(ProxyDurabilityIT.bytes("row"), Collections.singletonList(column));
        client.update(writer, cells);
        client.closeWriter(writer);
        Assert.assertEquals((long)1L, (long)this.count(tableName));
        this.restartTServer();
        Assert.assertEquals((long)0L, (long)this.count(tableName));
        ConditionalWriterOptions cfg = new ConditionalWriterOptions();
        cfg.setDurability(Durability.SYNC);
        String cwriter = client.createConditionalWriter(login, tableName, cfg);
        ConditionalUpdates updates = new ConditionalUpdates();
        updates.addToConditions(new Condition(new Column(ProxyDurabilityIT.bytes("cf"), ProxyDurabilityIT.bytes("cq"), ProxyDurabilityIT.bytes(""))));
        updates.addToUpdates(column);
        Map status = client.updateRowsConditionally(cwriter, Collections.singletonMap(ProxyDurabilityIT.bytes("row"), updates));
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, status.get(ProxyDurabilityIT.bytes("row")));
        Assert.assertEquals((long)1L, (long)this.count(tableName));
        this.restartTServer();
        Assert.assertEquals((long)1L, (long)this.count(tableName));
        proxyServer.stop();
    }

    private void restartTServer() throws Exception {
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.start();
    }

    private int count(String tableName) throws Exception {
        return Iterators.size((Iterator)this.getConnector().createScanner(tableName, Authorizations.EMPTY).iterator());
    }
}

