/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TokenFileIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File(System.getProperty("user.dir") + "/target"));

    @Test
    public void testMR() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        Connector c = this.getConnector();
        c.tableOperations().create(table1);
        c.tableOperations().create(table2);
        BatchWriter bw = c.createBatchWriter(table1, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        File tf = this.folder.newFile("root_test.pw");
        PrintStream out = new PrintStream(tf);
        String outString = new Credentials(TokenFileIT.getAdminPrincipal(), TokenFileIT.getAdminToken()).serialize();
        out.println(outString);
        out.close();
        MRTokenFileTester.main(new String[]{tf.getAbsolutePath(), table1, table2});
        Assert.assertNull((Object)e1);
        Scanner scanner = c.createScanner(table2, new Authorizations());
        Iterator iter = scanner.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Assert.assertEquals((long)Integer.parseInt(new String(((Value)entry.getValue()).get())), (long)100L);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private static class MRTokenFileTester
    extends Configured
    implements Tool {
        private MRTokenFileTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 3) {
                throw new IllegalArgumentException("Usage : " + MRTokenFileTester.class.getName() + " <token file> <inputtable> <outputtable>");
            }
            String user = AccumuloClusterHarness.getAdminPrincipal();
            String tokenFile = args[0];
            String table1 = args[1];
            String table2 = args[2];
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloInputFormat.class);
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)user, (String)tokenFile);
            AccumuloInputFormat.setInputTableName((Job)job, (String)table1);
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(AccumuloOutputFormat.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            AccumuloOutputFormat.setConnectorInfo((Job)job, (String)user, (String)tokenFile);
            AccumuloOutputFormat.setCreateTables((Job)job, (boolean)false);
            AccumuloOutputFormat.setDefaultTableName((Job)job, (String)table2);
            AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = CachedConfiguration.getInstance();
            conf.set("hadoop.tmp.dir", new File(args[0]).getParent());
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTokenFileTester(), (String[])args));
        }

        private static class TestMapper
        extends Mapper<Key, Value, Text, Mutation> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) throws IOException, InterruptedException {
                try {
                    if (this.key != null) {
                        Assert.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assert.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assert.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                Mutation m = new Mutation((CharSequence)"total");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)Integer.toString(this.count));
                context.write((Object)new Text(), (Object)m);
            }
        }
    }
}

