/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.impl.BatchInputSplit;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccumuloInputFormatIT
extends AccumuloClusterHarness {
    AccumuloInputFormat inputFormat;
    private static Multimap<String, AssertionError> assertionErrors = ArrayListMultimap.create();
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Before
    public void before() {
        this.inputFormat = new AccumuloInputFormat();
    }

    @Test
    public void testGetSplits() throws Exception {
        Connector conn = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        conn.tableOperations().create(table);
        this.insertData(table, System.currentTimeMillis());
        ClientConfiguration clientConf = cluster.getClientConfig();
        ConfigurationCopy clusterClientConf = new ConfigurationCopy((Iterable)new DefaultConfiguration());
        boolean sslEnabled = Boolean.valueOf(clusterClientConf.get(Property.INSTANCE_RPC_SSL_ENABLED));
        if (sslEnabled) {
            ClientConfiguration.ClientProperty[] sslProperties;
            for (ClientConfiguration.ClientProperty prop : sslProperties = new ClientConfiguration.ClientProperty[]{ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_PATH, ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_TYPE, ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_PASSWORD, ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_PATH, ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_TYPE, ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD, ClientConfiguration.ClientProperty.RPC_USE_JSSE, ClientConfiguration.ClientProperty.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS}) {
                clientConf.setProperty(prop, clusterClientConf.get(prop.getKey()));
            }
        }
        Job job = Job.getInstance();
        AccumuloInputFormat.setInputTableName((Job)job, (String)table);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
        TreeSet<Text> splitsToAdd = new TreeSet<Text>();
        for (int i = 0; i < 10000; i += 1000) {
            splitsToAdd.add(new Text(String.format("%09d", i)));
        }
        conn.tableOperations().addSplits(table, splitsToAdd);
        UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        Collection actualSplits = conn.tableOperations().listSplits(table);
        List splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)(actualSplits.size() + 1), (long)splits.size());
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Text text : actualSplits) {
            ranges.add(new Range(text));
        }
        AccumuloInputFormat.setRanges((Job)job, ranges);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)actualSplits.size(), (long)splits.size());
        AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
        try {
            this.inputFormat.getSplits((JobContext)job);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        conn.tableOperations().offline(table, true);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)actualSplits.size(), (long)splits.size());
        ranges = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            ranges.add(new Range((CharSequence)String.format("%09d", i), (CharSequence)String.format("%09d", i + 2)));
        }
        AccumuloInputFormat.setRanges((Job)job, ranges);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)2L, (long)splits.size());
        AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)false);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)ranges.size(), (long)splits.size());
        AccumuloInputFormat.setBatchScan((Job)job, (boolean)true);
        AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)true);
        AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
        try {
            this.inputFormat.getSplits((JobContext)job);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        conn.tableOperations().online(table, true);
        AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)false);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)2L, (long)splits.size());
        AccumuloInputFormat.setScanIsolation((Job)job, (boolean)true);
        try {
            this.inputFormat.getSplits((JobContext)job);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AccumuloInputFormat.setScanIsolation((Job)job, (boolean)false);
        splits = this.inputFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)2L, (long)splits.size());
        AccumuloInputFormat.setLocalIterators((Job)job, (boolean)true);
        try {
            this.inputFormat.getSplits((JobContext)job);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AccumuloInputFormat.setLocalIterators((Job)job, (boolean)false);
        conn.tableOperations().online(table);
        splits = this.inputFormat.getSplits((JobContext)job);
        for (InputSplit split : splits) {
            assert (split instanceof BatchInputSplit);
        }
        Assert.assertEquals((long)2L, (long)splits.size());
    }

    private void insertData(String tableName, long ts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        BatchWriter bw = this.getConnector().createBatchWriter(tableName, null);
        for (int i = 0; i < 10000; ++i) {
            String row = String.format("%09d", i);
            Mutation m = new Mutation(new Text(row));
            m.put(new Text("cf1"), new Text("cq1"), ts, new Value(("" + i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
    }

    @Test
    public void testMap() throws Exception {
        String TEST_TABLE_1 = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(TEST_TABLE_1);
        BatchWriter bw = c.createBatchWriter(TEST_TABLE_1, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{TEST_TABLE_1, AccumuloInputFormat.class.getName()}));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_1 + "_map")).size());
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_1 + "_cleanup")).size());
    }

    @Test
    public void testSample() throws Exception {
        String TEST_TABLE_3 = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(TEST_TABLE_3, new NewTableConfiguration().enableSampling(SAMPLER_CONFIG));
        BatchWriter bw = c.createBatchWriter(TEST_TABLE_3, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "False", "True"}));
        Assert.assertEquals((long)39L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
        Assert.assertEquals((long)2L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
        assertionErrors.clear();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "False", "False"}));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
        assertionErrors.clear();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "True", "True"}));
        Assert.assertEquals((long)39L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
        Assert.assertEquals((long)2L, (long)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
    }

    @Test
    public void testMapWithBatchScanner() throws Exception {
        String TEST_TABLE_2 = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(TEST_TABLE_2);
        BatchWriter bw = c.createBatchWriter(TEST_TABLE_2, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{TEST_TABLE_2, AccumuloInputFormat.class.getName(), "True", "False"}));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_2 + "_map")).size());
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(TEST_TABLE_2 + "_cleanup")).size());
    }

    @Test
    public void testCorrectRangeInputSplits() throws Exception {
        Job job = Job.getInstance();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        Connector connector = this.getConnector();
        connector.tableOperations().create(table);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
        AccumuloInputFormat.setInputTableName((Job)job, (String)table);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
        AccumuloInputFormat.setScanIsolation((Job)job, (boolean)isolated);
        AccumuloInputFormat.setLocalIterators((Job)job, (boolean)localIters);
        AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
        AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
        AccumuloInputFormat aif = new AccumuloInputFormat();
        List splits = aif.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
        InputSplit split = (InputSplit)splits.get(0);
        Assert.assertEquals(RangeInputSplit.class, split.getClass());
        RangeInputSplit risplit = (RangeInputSplit)split;
        Assert.assertEquals((Object)AccumuloInputFormatIT.getAdminPrincipal(), (Object)risplit.getPrincipal());
        Assert.assertEquals((Object)table, (Object)risplit.getTableName());
        Assert.assertEquals((Object)AccumuloInputFormatIT.getAdminToken(), (Object)risplit.getToken());
        Assert.assertEquals((Object)auths, (Object)risplit.getAuths());
        Assert.assertEquals((Object)this.getConnector().getInstance().getInstanceName(), (Object)risplit.getInstanceName());
        Assert.assertEquals((Object)isolated, (Object)risplit.isIsolatedScan());
        Assert.assertEquals((Object)localIters, (Object)risplit.usesLocalIterators());
        Assert.assertEquals(fetchColumns, (Object)risplit.getFetchedColumns());
        Assert.assertEquals((Object)level, (Object)risplit.getLogLevel());
    }

    @Test(expected=IOException.class)
    public void testGetSplitsNoReadPermission() throws Exception {
        Job job = Job.getInstance();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        Connector connector = this.getConnector();
        connector.tableOperations().create(table);
        connector.securityOperations().revokeTablePermission(connector.whoami(), table, TablePermission.READ);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
        AccumuloInputFormat.setInputTableName((Job)job, (String)table);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
        AccumuloInputFormat.setScanIsolation((Job)job, (boolean)isolated);
        AccumuloInputFormat.setLocalIterators((Job)job, (boolean)localIters);
        AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
        AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
        AccumuloInputFormat aif = new AccumuloInputFormat();
        aif.getSplits((JobContext)job);
    }

    @Test
    public void testGetSplitsWithNamespaceReadPermission() throws Exception {
        Job job = Job.getInstance();
        String[] namespaceAndTable = this.getUniqueNames(2);
        String namespace = namespaceAndTable[0];
        String tableSimpleName = namespaceAndTable[1];
        String table = namespace + "." + tableSimpleName;
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(namespace);
        connector.tableOperations().create(table);
        connector.securityOperations().revokeTablePermission(connector.whoami(), table, TablePermission.READ);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
        AccumuloInputFormat.setInputTableName((Job)job, (String)table);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
        AccumuloInputFormat.setScanIsolation((Job)job, (boolean)true);
        AccumuloInputFormat.setLocalIterators((Job)job, (boolean)true);
        AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
        AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
        AccumuloInputFormat aif = new AccumuloInputFormat();
        List splits = aif.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
    }

    @Test
    public void testPartialInputSplitDelegationToConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(table);
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)0L, (long)MRTester.main(new String[]{table, EmptySplitsAccumuloInputFormat.class.getName()}));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(table + "_map")).size());
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(table + "_cleanup")).size());
    }

    @Test
    public void testPartialFailedInputSplitDelegationToConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(table);
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
            m.put(new Text(), new Text(), new Value(String.format("%09x", i).getBytes()));
            bw.addMutation(m);
        }
        bw.close();
        Assert.assertEquals((long)1L, (long)MRTester.main(new String[]{table, BadPasswordSplitsAccumuloInputFormat.class.getName()}));
        Assert.assertEquals((long)1L, (long)assertionErrors.get((Object)(table + "_map")).size());
        Assert.assertEquals((long)2L, (long)assertionErrors.get((Object)(table + "_cleanup")).size());
    }

    public static class EmptySplitsAccumuloInputFormat
    extends AccumuloInputFormat {
        public List<InputSplit> getSplits(JobContext context) throws IOException {
            List oldSplits = super.getSplits(context);
            ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(oldSplits.size());
            for (InputSplit oldSplit : oldSplits) {
                RangeInputSplit newSplit = new RangeInputSplit((RangeInputSplit)oldSplit);
                newSplits.add((InputSplit)newSplit);
            }
            return newSplits;
        }
    }

    public static class BadPasswordSplitsAccumuloInputFormat
    extends AccumuloInputFormat {
        public List<InputSplit> getSplits(JobContext context) throws IOException {
            List splits = super.getSplits(context);
            for (InputSplit split : splits) {
                RangeInputSplit rangeSplit = (RangeInputSplit)split;
                rangeSplit.setToken((AuthenticationToken)new PasswordToken((CharSequence)"anythingelse"));
            }
            return splits;
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2 && args.length != 4) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> <inputFormatClass> [<batchScan> <scan sample>]");
            }
            String table = args[0];
            String inputFormatClassName = args[1];
            Boolean batchScan = false;
            boolean sample = false;
            if (args.length == 4) {
                batchScan = Boolean.parseBoolean(args[2]);
                sample = Boolean.parseBoolean(args[3]);
            }
            assertionErrors.put((Object)(table + "_map"), (Object)new AssertionError((Object)"Dummy_map"));
            assertionErrors.put((Object)(table + "_cleanup"), (Object)new AssertionError((Object)"Dummy_cleanup"));
            Class<?> inputFormatClass = Class.forName(inputFormatClassName);
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.getConfiguration().set("MRTester_tableName", table);
            job.setInputFormatClass(inputFormatClass);
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloClusterHarness.getAdminPrincipal(), (AuthenticationToken)AccumuloClusterHarness.getAdminToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloInputFormat.setBatchScan((Job)job, (boolean)batchScan);
            if (sample) {
                AccumuloInputFormat.setSamplerConfiguration((Job)job, (SamplerConfiguration)SAMPLER_CONFIG);
            }
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static int main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            return ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args);
        }

        private static class TestMapper
        extends Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) throws IOException, InterruptedException {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                try {
                    if (this.key != null) {
                        Assert.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assert.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assert.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_map"), (Object)e);
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assert.assertNotNull((Object)table);
                try {
                    Assert.assertEquals((long)100L, (long)this.count);
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_cleanup"), (Object)e);
                }
            }
        }
    }
}

