/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapred.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloFileOutputFormatIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(AccumuloFileOutputFormatIT.class);
    private static final int JOB_VISIBILITY_CACHE_SIZE = 3000;
    private static final String PREFIX = AccumuloFileOutputFormatIT.class.getSimpleName();
    private static final String BAD_TABLE = PREFIX + "_mapred_bad_table";
    private static final String TEST_TABLE = PREFIX + "_mapred_test_table";
    private static final String EMPTY_TABLE = PREFIX + "_mapred_empty_table";
    private static AssertionError e1 = null;
    private static AssertionError e2 = null;
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File(System.getProperty("user.dir") + "/target"));

    @Test
    public void testEmptyWrite() throws Exception {
        this.getConnector().tableOperations().create(EMPTY_TABLE);
        this.handleWriteTests(false);
    }

    @Test
    public void testRealWrite() throws Exception {
        Connector c = this.getConnector();
        c.tableOperations().create(TEST_TABLE);
        BatchWriter bw = c.createBatchWriter(TEST_TABLE, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"Key");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
        bw.addMutation(m);
        bw.close();
        this.handleWriteTests(true);
    }

    private void handleWriteTests(boolean content) throws Exception {
        File f = this.folder.newFile(this.testName.getMethodName());
        if (f.delete()) {
            log.debug("Deleted {}", (Object)f);
        }
        MRTester.main(new String[]{content ? TEST_TABLE : EMPTY_TABLE, f.getAbsolutePath()});
        Assert.assertTrue((boolean)f.exists());
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("part-m-");
            }
        });
        Assert.assertNotNull((Object)files);
        if (content) {
            Assert.assertEquals((long)1L, (long)files.length);
            Assert.assertTrue((boolean)files[0].exists());
            Configuration conf = CachedConfiguration.getInstance();
            DefaultConfiguration acuconf = DefaultConfiguration.getInstance();
            FileSKVIterator sample = ((FileOperations.OpenReaderOperationBuilder)RFileOperations.getInstance().newReaderBuilder().forFile(files[0].toString(), (FileSystem)FileSystem.getLocal((Configuration)conf), conf).withTableConfiguration((AccumuloConfiguration)acuconf)).build().getSample(new SamplerConfigurationImpl(SAMPLER_CONFIG));
            Assert.assertNotNull((Object)sample);
        } else {
            Assert.assertEquals((long)0L, (long)files.length);
        }
    }

    @Test
    public void writeBadVisibility() throws Exception {
        Connector c = this.getConnector();
        c.tableOperations().create(BAD_TABLE);
        BatchWriter bw = c.createBatchWriter(BAD_TABLE, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"r1");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"A&B");
        m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"A&B");
        m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"A&");
        bw.addMutation(m);
        bw.close();
        File f = this.folder.newFile(this.testName.getMethodName());
        if (f.delete()) {
            log.debug("Deleted {}", (Object)f);
        }
        MRTester.main(new String[]{BAD_TABLE, f.getAbsolutePath()});
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> <outputfile>");
            }
            String table = args[0];
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            ConfiguratorBase.setVisibilityCacheSize((Configuration)job, (int)3000);
            job.setInputFormat(AccumuloInputFormat.class);
            AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)AccumuloClusterHarness.getAdminPrincipal(), (AuthenticationToken)AccumuloClusterHarness.getAdminToken());
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
            AccumuloFileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
            AccumuloFileOutputFormat.setSampler((JobConf)job, (SamplerConfiguration)SAMPLER_CONFIG);
            job.setMapperClass(BAD_TABLE.equals(table) ? BadKeyMapper.class : IdentityMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(AccumuloFileOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class BadKeyMapper
        implements Mapper<Key, Value, Key, Value> {
            int index = 0;

            private BadKeyMapper() {
            }

            public void map(Key key, Value value, OutputCollector<Key, Value> output, Reporter reporter) throws IOException {
                try {
                    try {
                        output.collect((Object)key, (Object)value);
                        if (this.index == 2) {
                            Assert.fail();
                        }
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                        Assert.assertEquals((long)2L, (long)this.index);
                    }
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                ++this.index;
            }

            public void configure(JobConf job) {
            }

            public void close() throws IOException {
                try {
                    Assert.assertEquals((long)2L, (long)this.index);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

