/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BinaryIT;
import org.apache.accumulo.test.functional.BulkIT;
import org.apache.accumulo.test.functional.ConcurrencyIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.MapReduceIT;
import org.apache.accumulo.test.functional.ShutdownIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Test;

public class SslIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 360;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        super.configure(cfg, hadoopCoreSite);
        SslIT.configureForSsl(cfg, SslIT.getSslDir(SslIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName())));
    }

    @Test
    public void binary() throws AccumuloException, AccumuloSecurityException, Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.getConnector().tableOperations().create(tableName);
        BinaryIT.runTest(this.getConnector(), tableName);
    }

    @Test
    public void concurrency() throws Exception {
        ConcurrencyIT.runTest(this.getConnector(), this.getUniqueNames(1)[0]);
    }

    @Test
    public void adminStop() throws Exception {
        ShutdownIT.runAdminStopTest(this.getConnector(), this.getCluster());
    }

    @Test
    public void bulk() throws Exception {
        BulkIT.runTest(this.getConnector(), this.cluster.getFileSystem(), new Path(this.getCluster().getConfig().getDir().getAbsolutePath(), "tmp"), "root", this.getUniqueNames(1)[0], this.getClass().getName(), this.testName.getMethodName());
    }

    @Test
    public void mapReduce() throws Exception {
        MapReduceIT.runTest(this.getConnector(), this.getCluster());
    }
}

