/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanSessionTimeOutIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanSessionTimeOutIT.class);
    private String sessionIdle = null;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_SESSION_MAXIDLE.getKey(), this.getMaxIdleTimeString());
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void reduceSessionIdle() throws Exception {
        InstanceOperations ops = this.getConnector().instanceOperations();
        this.sessionIdle = (String)ops.getSystemConfiguration().get(Property.TSERV_SESSION_MAXIDLE.getKey());
        ops.setProperty(Property.TSERV_SESSION_MAXIDLE.getKey(), this.getMaxIdleTimeString());
        log.info("Waiting for existing session idle time to expire");
        Thread.sleep(AccumuloConfiguration.getTimeInMillis((String)this.sessionIdle));
        log.info("Finished waiting");
    }

    protected String getMaxIdleTimeString() {
        return "3";
    }

    @After
    public void resetSessionIdle() throws Exception {
        if (null != this.sessionIdle) {
            this.getConnector().instanceOperations().setProperty(Property.TSERV_SESSION_MAXIDLE.getKey(), this.sessionIdle);
        }
    }

    @Test
    public void run() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 0; i < 100000; ++i) {
            Mutation m = new Mutation(new Text(String.format("%08d", i)));
            for (int j = 0; j < 3; ++j) {
                m.put(new Text("cf1"), new Text("cq" + j), new Value((i + "_" + j).getBytes(StandardCharsets.UTF_8)));
            }
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner = c.createScanner(tableName, new Authorizations());
        scanner.setBatchSize(1000);
        Iterator iter = scanner.iterator();
        this.verify(iter, 0, 200);
        UtilWaitThread.sleepUninterruptibly((long)9L, (TimeUnit)TimeUnit.SECONDS);
        this.verify(iter, 200, 100000);
    }

    protected void verify(Iterator<Map.Entry<Key, Value>> iter, int start, int stop) throws Exception {
        for (int i = start; i < stop; ++i) {
            Text er = new Text(String.format("%08d", i));
            for (int j = 0; j < 3; ++j) {
                Map.Entry<Key, Value> entry = iter.next();
                if (!entry.getKey().getRow().equals((Object)er)) {
                    throw new Exception("row " + entry.getKey().getRow() + " != " + er);
                }
                if (!entry.getKey().getColumnFamily().equals((Object)new Text("cf1"))) {
                    throw new Exception("cf " + entry.getKey().getColumnFamily() + " != cf1");
                }
                if (!entry.getKey().getColumnQualifier().equals((Object)new Text("cq" + j))) {
                    throw new Exception("cq " + entry.getKey().getColumnQualifier() + " != cq" + j);
                }
                if (entry.getValue().toString().equals("" + i + "_" + j)) continue;
                throw new Exception("value " + entry.getValue() + " != " + i + "_" + j);
            }
        }
    }
}

