/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MaxOpenIT
extends AccumuloClusterHarness {
    private String scanMaxOpenFiles;
    private String majcConcurrent;
    private String majcThreadMaxOpen;
    private static final int NUM_TABLETS = 16;
    private static final int NUM_TO_INGEST = 10000;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map conf = cfg.getSiteConfig();
        conf.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), "4");
        conf.put(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), "1");
        conf.put(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), "2");
        cfg.setSiteConfig(conf);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 180;
    }

    @Before
    public void alterConfig() throws Exception {
        InstanceOperations iops = this.getConnector().instanceOperations();
        Map sysConfig = iops.getSystemConfiguration();
        this.scanMaxOpenFiles = (String)sysConfig.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey());
        this.majcConcurrent = (String)sysConfig.get(Property.TSERV_MAJC_MAXCONCURRENT.getKey());
        this.majcThreadMaxOpen = (String)sysConfig.get(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey());
    }

    @After
    public void restoreConfig() throws Exception {
        InstanceOperations iops = this.getConnector().instanceOperations();
        if (null != this.scanMaxOpenFiles) {
            iops.setProperty(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), this.scanMaxOpenFiles);
        }
        if (null != this.majcConcurrent) {
            iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), this.majcConcurrent);
        }
        if (null != this.majcThreadMaxOpen) {
            iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), this.majcThreadMaxOpen);
        }
    }

    @Test
    public void run() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        ClientConfiguration clientConf = cluster.getClientConfig();
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "10");
        c.tableOperations().addSplits(tableName, TestIngest.getSplitPoints(0L, 10000L, 16L));
        for (int i = 0; i < 3; ++i) {
            TestIngest.Opts opts = new TestIngest.Opts();
            opts.timestamp = i;
            opts.dataSize = 50;
            opts.rows = 10000;
            opts.cols = 1;
            opts.random = i;
            opts.setTableName(tableName);
            if (clientConf.hasSasl()) {
                opts.updateKerberosCredentials(clientConf);
            } else {
                opts.setPrincipal(MaxOpenIT.getAdminPrincipal());
            }
            TestIngest.ingest(c, opts, new BatchWriterOpts());
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 16, 16, i + 1, i + 1);
        }
        ArrayList<Range> ranges = new ArrayList<Range>(10000);
        for (int i = 0; i < 10000; ++i) {
            ranges.add(new Range(TestIngest.generateRow(i, 0)));
        }
        long time1 = this.batchScan(c, tableName, ranges, 1);
        time1 = this.batchScan(c, tableName, ranges, 1);
        long time2 = this.batchScan(c, tableName, ranges, 16);
        System.out.printf("Single thread scan time   %6.2f %n", (double)time1 / 1000.0);
        System.out.printf("Multiple thread scan time %6.2f %n", (double)time2 / 1000.0);
    }

    private long batchScan(Connector c, String tableName, List<Range> ranges, int threads) throws Exception {
        BatchScanner bs = c.createBatchScanner(tableName, TestIngest.AUTHS, threads);
        bs.setRanges(ranges);
        int count = 0;
        long t1 = System.currentTimeMillis();
        byte[] rval = new byte[50];
        Random random = new Random();
        for (Map.Entry entry : bs) {
            ++count;
            int row = VerifyIngest.getRow((Key)entry.getKey());
            int col = VerifyIngest.getCol((Key)entry.getKey());
            if (row < 0 || row >= 10000) {
                throw new Exception("unexcepted row " + row);
            }
            rval = TestIngest.genRandomValue(random, rval, 2, row, col);
            if (((Value)entry.getValue()).compareTo(rval) == 0) continue;
            throw new Exception("unexcepted value row=" + row + " col=" + col);
        }
        long t2 = System.currentTimeMillis();
        bs.close();
        if (count != 10000) {
            throw new Exception("Batch Scan did not return expected number of values " + count);
        }
        return t2 - t1;
    }
}

