/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeRowIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(LargeRowIT.class);
    private static final int SEED = 42;
    private static final int NUM_ROWS = 100;
    private static final int ROW_SIZE = 131072;
    private static final int NUM_PRE_SPLITS = 9;
    private static final int SPLIT_THRESH = 1456355;
    private String REG_TABLE_NAME;
    private String PRE_SPLIT_TABLE_NAME;
    private int timeoutFactor = 1;
    private String tservMajcDelay;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setMemory(ServerType.TABLET_SERVER, cfg.getMemory(ServerType.TABLET_SERVER) * 2L, MemoryUnit.BYTE);
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "10ms");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void getTimeoutFactor() throws Exception {
        try {
            this.timeoutFactor = Integer.parseInt(System.getProperty("timeout.factor"));
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse property value for 'timeout.factor' as integer: " + System.getProperty("timeout.factor"));
        }
        Assert.assertTrue((String)"Timeout factor must be greater than or equal to 1", (this.timeoutFactor >= 1 ? 1 : 0) != 0);
        String[] names = this.getUniqueNames(2);
        this.REG_TABLE_NAME = names[0];
        this.PRE_SPLIT_TABLE_NAME = names[1];
        Connector c = this.getConnector();
        this.tservMajcDelay = (String)c.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
        c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "10ms");
    }

    @After
    public void resetMajcDelay() throws Exception {
        if (null != this.tservMajcDelay) {
            Connector conn = this.getConnector();
            conn.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.tservMajcDelay);
        }
    }

    @Test
    public void run() throws Exception {
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(43L);
        TreeSet<Text> splitPoints = new TreeSet<Text>();
        for (int i = 0; i < 9; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            splitPoints.add(new Text(rowData));
        }
        Connector c = this.getConnector();
        c.tableOperations().create(this.REG_TABLE_NAME);
        c.tableOperations().create(this.PRE_SPLIT_TABLE_NAME);
        c.tableOperations().setProperty(this.PRE_SPLIT_TABLE_NAME, Property.TABLE_MAX_END_ROW_SIZE.getKey(), "256K");
        UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        c.tableOperations().addSplits(this.PRE_SPLIT_TABLE_NAME, splitPoints);
        this.test1(c);
        this.test2(c);
    }

    private void test1(Connector c) throws Exception {
        this.basicTest(c, this.REG_TABLE_NAME, 0);
        c.tableOperations().setProperty(this.REG_TABLE_NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "1456355");
        UtilWaitThread.sleepUninterruptibly((long)(this.timeoutFactor * 12), (TimeUnit)TimeUnit.SECONDS);
        log.info("checking splits");
        FunctionalTestUtils.checkSplits(c, this.REG_TABLE_NAME, 4, 36);
        this.verify(c, this.REG_TABLE_NAME);
    }

    private void test2(Connector c) throws Exception {
        this.basicTest(c, this.PRE_SPLIT_TABLE_NAME, 9);
    }

    private void basicTest(Connector c, String table, int expectedSplits) throws Exception {
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(42L);
        for (int i = 0; i < 100; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            Mutation mut = new Mutation(new Text(rowData));
            mut.put(new Text(""), new Text(""), new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(mut);
        }
        bw.close();
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        this.verify(c, table);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        c.tableOperations().flush(table, null, null, false);
        this.verify(c, table);
        c.tableOperations().flush(table, null, null, true);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        this.verify(c, table);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
    }

    private void verify(Connector c, String table) throws Exception {
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(42L);
        Scanner scanner = c.createScanner(table, Authorizations.EMPTY);
        for (int i = 0; i < 100; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            scanner.setRange(new Range(new Text(rowData)));
            int count = 0;
            for (Map.Entry entry : scanner) {
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(rowData))) {
                    throw new Exception("verification failed, unexpected row i =" + i);
                }
                if (!((Value)entry.getValue()).equals((Object)new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)))) {
                    throw new Exception("verification failed, unexpected value i =" + i + " value = " + entry.getValue());
                }
                ++count;
            }
            if (count == true) continue;
            throw new Exception("verification failed, unexpected count i =" + i + " count=" + count);
        }
    }
}

