/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.EnumSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeletedTablesDontFlushIT
extends SharedMiniClusterBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void test() throws Exception {
        Connector c = DeletedTablesDontFlushIT.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        IteratorSetting setting = new IteratorSetting(100, SlowIterator.class);
        SlowIterator.setSleepTime(setting, 1000L);
        c.tableOperations().attachIterator(tableName, setting, EnumSet.of(IteratorUtil.IteratorScope.minc));
        UtilWaitThread.sleep((long)1000L);
        Mutation m = new Mutation((CharSequence)"xyzzy");
        for (int i = 0; i < 100; ++i) {
            m.put((CharSequence)"cf", (CharSequence)("" + i), new Value(new byte[0]));
        }
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        bw.addMutation(m);
        bw.close();
        c.tableOperations().delete(tableName);
    }
}

