/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CleanUp;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(CleanUpIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 30;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        CleanUpIT.getConnector().tableOperations().create(tableName);
        BatchWriter bw = CleanUpIT.getConnector().createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m1 = new Mutation((CharSequence)"r1");
        m1.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"5");
        bw.addMutation(m1);
        bw.flush();
        Scanner scanner = CleanUpIT.getConnector().createScanner(tableName, new Authorizations());
        int count = 0;
        for (Map.Entry entry : scanner) {
            ++count;
            if (((Value)entry.getValue()).toString().equals("5")) continue;
            Assert.fail((String)("Unexpected value " + entry.getValue()));
        }
        Assert.assertEquals((String)"Unexpected count", (long)1L, (long)count);
        int threadCount = this.countThreads();
        if (threadCount < 2) {
            this.printThreadNames();
            Assert.fail((String)("Not seeing expected threads. Saw " + threadCount));
        }
        CleanUp.shutdownNow();
        Mutation m2 = new Mutation((CharSequence)"r2");
        m2.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"6");
        try {
            bw.addMutation(m1);
            bw.flush();
            Assert.fail((String)"batch writer did not fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bw.close();
            Assert.fail((String)"batch writer close not fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            count = 0;
            Iterator iter = scanner.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            Assert.fail((String)"scanner did not fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        threadCount = this.countThreads();
        if (threadCount > 0) {
            this.printThreadNames();
            Assert.fail((String)("Threads did not go away. Saw " + threadCount));
        }
    }

    private void printThreadNames() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        Exception e = new Exception();
        for (Thread thread : threads) {
            e.setStackTrace(thread.getStackTrace());
            log.info("thread name: " + thread.getName(), (Throwable)e);
        }
    }

    private int countThreads() {
        int count = 0;
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (thread.getName().toLowerCase().contains("sendthread") || thread.getName().toLowerCase().contains("eventthread")) {
                ++count;
            }
            if (!thread.getName().toLowerCase().contains("thrift") || !thread.getName().toLowerCase().contains("pool")) continue;
            ++count;
        }
        return count;
    }
}

