/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.master.balancer.ChaoticLoadBalancer;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class ChaoticBalancerIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "10K");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "0");
        siteConfig.put(Property.TABLE_LOAD_BALANCER.getKey(), ChaoticLoadBalancer.class.getName());
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String[] names = this.getUniqueNames(1);
        String tableName = names[0];
        NewTableConfiguration ntc = new NewTableConfiguration();
        ntc.setProperties(Stream.of(new Pair((Object)Property.TABLE_SPLIT_THRESHOLD.getKey(), (Object)"10K"), new Pair((Object)Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), (Object)"1K")).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        c.tableOperations().create(tableName, ntc);
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        opts.rows = 20000;
        vopts.rows = 20000;
        opts.setTableName(tableName);
        vopts.setTableName(tableName);
        ClientConfiguration clientConfig = ChaoticBalancerIT.getCluster().getClientConfig();
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(ChaoticBalancerIT.getAdminPrincipal());
            vopts.setPrincipal(ChaoticBalancerIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        c.tableOperations().flush(tableName, null, null, true);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
    }
}

