/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.keyfunctor.ColumnFamilyFunctor;
import org.apache.accumulo.core.file.keyfunctor.ColumnQualifierFunctor;
import org.apache.accumulo.core.file.keyfunctor.RowFunctor;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BloomFilterIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setDefaultMemory(1L, MemoryUnit.GIGABYTE);
        cfg.setNumTservers(1);
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10M");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 360;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String readAhead = (String)c.instanceOperations().getSystemConfiguration().get(Property.TSERV_READ_AHEAD_MAXCONCURRENT.getKey());
        c.instanceOperations().setProperty(Property.TSERV_READ_AHEAD_MAXCONCURRENT.getKey(), "1");
        try {
            String[] tables;
            Thread.sleep(1000L);
            for (String table : tables = this.getUniqueNames(4)) {
                TableOperations tops = c.tableOperations();
                tops.create(table);
                tops.setProperty(table, Property.TABLE_INDEXCACHE_ENABLED.getKey(), "false");
                tops.setProperty(table, Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "false");
                tops.setProperty(table, Property.TABLE_BLOOM_SIZE.getKey(), "2000000");
                tops.setProperty(table, Property.TABLE_BLOOM_ERRORRATE.getKey(), "1%");
                tops.setProperty(table, Property.TABLE_BLOOM_LOAD_THRESHOLD.getKey(), "0");
                tops.setProperty(table, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "64K");
            }
            log.info("Writing");
            this.write(c, tables[0], 1, 0L, 2000000000L, 500);
            this.write(c, tables[1], 2, 0L, 2000000000L, 500);
            this.write(c, tables[2], 3, 0L, 2000000000L, 500);
            log.info("Writing complete");
            BatchWriter bw = c.createBatchWriter(tables[3], new BatchWriterConfig());
            Mutation m = new Mutation(new Text(""));
            m.put(new Text(""), new Text(""), new Value("foo1".getBytes()));
            bw.addMutation(m);
            bw.close();
            c.tableOperations().flush(tables[3], null, null, true);
            for (String table : Arrays.asList(tables[0], tables[1], tables[2])) {
                c.tableOperations().compact(table, null, null, true, true);
            }
            for (String table : tables) {
                FunctionalTestUtils.checkRFiles(c, table, 1, 1, 1, 1);
            }
            log.info("Base query");
            long t1 = this.query(c, tables[0], 1, 0L, 2000000000L, 5000, 500);
            long t2 = this.query(c, tables[1], 2, 0L, 2000000000L, 5000, 500);
            long t3 = this.query(c, tables[2], 3, 0L, 2000000000L, 5000, 500);
            log.info("Base query complete");
            log.info("Rewriting with bloom filters");
            c.tableOperations().setProperty(tables[0], Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            c.tableOperations().setProperty(tables[0], Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), RowFunctor.class.getName());
            c.tableOperations().setProperty(tables[1], Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            c.tableOperations().setProperty(tables[1], Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), ColumnFamilyFunctor.class.getName());
            c.tableOperations().setProperty(tables[2], Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            c.tableOperations().setProperty(tables[2], Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), ColumnQualifierFunctor.class.getName());
            c.tableOperations().setProperty(tables[3], Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            c.tableOperations().setProperty(tables[3], Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), RowFunctor.class.getName());
            UtilWaitThread.sleep((long)500L);
            c.tableOperations().compact(tables[3], null, null, false, true);
            c.tableOperations().compact(tables[0], null, null, false, true);
            c.tableOperations().compact(tables[1], null, null, false, true);
            c.tableOperations().compact(tables[2], null, null, false, true);
            log.info("Rewriting with bloom filters complete");
            log.info("Bloom query");
            long tb1 = this.query(c, tables[0], 1, 0L, 2000000000L, 5000, 500);
            long tb2 = this.query(c, tables[1], 2, 0L, 2000000000L, 5000, 500);
            long tb3 = this.query(c, tables[2], 3, 0L, 2000000000L, 5000, 500);
            log.info("Bloom query complete");
            this.timeCheck(t1 + t2 + t3, tb1 + tb2 + tb3);
            Scanner scanner = c.createScanner(tables[3], Authorizations.EMPTY);
            scanner.setRange(new Range(new Text("")));
            if (!((Value)((Map.Entry)scanner.iterator().next()).getValue()).toString().equals("foo1")) {
                throw new Exception("Did not see foo1");
            }
        }
        finally {
            c.instanceOperations().setProperty(Property.TSERV_READ_AHEAD_MAXCONCURRENT.getKey(), readAhead);
        }
    }

    private void timeCheck(long t1, long t2) throws Exception {
        double improvement = (double)(t1 - t2) * 1.0 / (double)t1;
        if (improvement < 0.1) {
            throw new Exception("Queries had less than 10% improvement (old: " + t1 + " new: " + t2 + " improvement: " + improvement * 100.0 + "%)");
        }
        log.info(String.format("Improvement: %.2f%% (%d vs %d)", improvement * 100.0, t1, t2));
    }

    private long query(Connector c, String table, int depth, long start, long end, int num, int step) throws Exception {
        Random r = new Random(42L);
        HashSet<Long> expected = new HashSet<Long>();
        ArrayList<Range> ranges = new ArrayList<Range>(num);
        Text key = new Text();
        Text row = new Text("row");
        Text cq = new Text("cq");
        Text cf = new Text("cf");
        for (int i = 0; i < num; ++i) {
            Long k = (r.nextLong() & Long.MAX_VALUE) % (end - start) + start;
            key.set(String.format("k_%010d", k));
            Range range = null;
            if (k % (start + (long)step) == 0L) {
                expected.add(k);
            }
            switch (depth) {
                case 1: {
                    range = new Range(new Text(key));
                    break;
                }
                case 2: {
                    Iterator acuKey = new Key(row, key, cq);
                    range = new Range((Key)acuKey, true, acuKey.followingKey(PartialKey.ROW_COLFAM), false);
                    break;
                }
                case 3: {
                    Iterator acuKey = new Key(row, cf, key);
                    range = new Range((Key)acuKey, true, acuKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL), false);
                }
            }
            ranges.add(range);
        }
        BatchScanner bs = c.createBatchScanner(table, Authorizations.EMPTY, 1);
        bs.setRanges(ranges);
        long t1 = System.currentTimeMillis();
        for (Map.Entry entry : bs) {
            long v = Long.parseLong(((Value)entry.getValue()).toString());
            if (expected.remove(v)) continue;
            throw new Exception("Got unexpected return " + entry.getKey() + " " + entry.getValue());
        }
        long t2 = System.currentTimeMillis();
        if (expected.size() > 0) {
            throw new Exception("Did not get all expected values " + expected.size());
        }
        bs.close();
        return t2 - t1;
    }

    private void write(Connector c, String table, int depth, long start, long end, int step) throws Exception {
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        for (long i = start; i < end; i += (long)step) {
            String key = String.format("k_%010d", i);
            Mutation m = null;
            switch (depth) {
                case 1: {
                    m = new Mutation(new Text(key));
                    m.put(new Text("cf"), new Text("cq"), new Value(("" + i).getBytes()));
                    break;
                }
                case 2: {
                    m = new Mutation(new Text("row"));
                    m.put(new Text(key), new Text("cq"), new Value(("" + i).getBytes()));
                    break;
                }
                case 3: {
                    m = new Mutation(new Text("row"));
                    m.put(new Text("cf"), new Text(key), new Value(("" + i).getBytes()));
                }
            }
            bw.addMutation(m);
        }
        bw.close();
        c.tableOperations().flush(table, null, null, true);
    }
}

