/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class WaitForBalanceIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        Iterators.size((Iterator)c.createScanner("accumulo.metadata", Authorizations.EMPTY).iterator());
        c.instanceOperations().waitForBalance();
        Assert.assertTrue((boolean)this.isBalanced());
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.instanceOperations().waitForBalance();
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        for (int i = 0; i < 1000; ++i) {
            partitionKeys.add(new Text("" + i));
        }
        c.tableOperations().addSplits(tableName, partitionKeys);
        Assert.assertFalse((boolean)this.isBalanced());
        c.instanceOperations().waitForBalance();
        Assert.assertTrue((boolean)this.isBalanced());
    }

    private boolean isBalanced() throws Exception {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        int offline = 0;
        Connector c = this.getConnector();
        for (String tableName : new String[]{"accumulo.metadata", "accumulo.root"}) {
            Scanner s = c.createScanner(tableName, Authorizations.EMPTY);
            s.setRange(MetadataSchema.TabletsSection.getRange());
            s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)s);
            String location = null;
            for (Map.Entry entry : s) {
                Key key = (Key)entry.getKey();
                if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                    location = key.getColumnQualifier().toString();
                    continue;
                }
                if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
                if (location == null) {
                    ++offline;
                } else {
                    Integer count = (Integer)counts.get(location);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    counts.put(location, count);
                }
                location = null;
            }
        }
        if (offline > 1) {
            System.out.println("Offline tablets " + offline);
            return false;
        }
        int average = 0;
        for (Integer i : counts.values()) {
            average += i.intValue();
        }
        average /= counts.size();
        System.out.println(counts);
        int tablesCount = c.tableOperations().list().size();
        for (Map.Entry hostCount : counts.entrySet()) {
            if (Math.abs(average - (Integer)hostCount.getValue()) <= tablesCount) continue;
            System.out.println("Average " + average + " count " + (String)hostCount.getKey() + ": " + hostCount.getValue());
            return false;
        }
        return true;
    }
}

