/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRandomDeletes {
    private static final Logger log = LoggerFactory.getLogger(TestRandomDeletes.class);
    private static Authorizations auths = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});

    private static TreeSet<RowColumn> scanAll(ClientOnDefaultTable opts, ScannerOpts scanOpts, String tableName) throws Exception {
        TreeSet<RowColumn> result = new TreeSet<RowColumn>();
        Connector conn = opts.getConnector();
        Scanner scanner = conn.createScanner(tableName, auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            Column column = new Column(TextUtil.getBytes((Text)key.getColumnFamily()), TextUtil.getBytes((Text)key.getColumnQualifier()), TextUtil.getBytes((Text)key.getColumnVisibility()));
            result.add(new RowColumn(key.getRow(), column, key.getTimestamp()));
        }
        return result;
    }

    private static long scrambleDeleteHalfAndCheck(ClientOnDefaultTable opts, ScannerOpts scanOpts, BatchWriterOpts bwOpts, String tableName, Set<RowColumn> rows) throws Exception {
        int result = 0;
        ArrayList<RowColumn> entries = new ArrayList<RowColumn>(rows);
        Collections.shuffle(entries);
        Connector connector = opts.getConnector();
        BatchWriter mutations = connector.createBatchWriter(tableName, bwOpts.getBatchWriterConfig());
        for (int i = 0; i < (entries.size() + 1) / 2; ++i) {
            RowColumn rc = entries.get(i);
            Mutation m = new Mutation(rc.row);
            m.putDelete(new Text(rc.column.columnFamily), new Text(rc.column.columnQualifier), new ColumnVisibility(rc.column.getColumnVisibility()), rc.timestamp + 1L);
            mutations.addMutation(m);
            rows.remove(rc);
            ++result;
        }
        mutations.close();
        TreeSet<RowColumn> current = TestRandomDeletes.scanAll(opts, scanOpts, tableName);
        current.removeAll(rows);
        if (current.size() > 0) {
            throw new RuntimeException(current.size() + " records not deleted");
        }
        return result;
    }

    public static void main(String[] args) {
        ClientOnDefaultTable opts = new ClientOnDefaultTable("test_ingest");
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(TestRandomDeletes.class.getName(), args, new Object[]{scanOpts, bwOpts});
        log.info("starting random delete test");
        try {
            long half;
            long deleted = 0L;
            String tableName = opts.getTableName();
            TreeSet<RowColumn> doomed = TestRandomDeletes.scanAll(opts, scanOpts, tableName);
            log.info("Got " + doomed.size() + " rows");
            long startTime = System.currentTimeMillis();
            do {
                half = TestRandomDeletes.scrambleDeleteHalfAndCheck(opts, scanOpts, bwOpts, tableName, doomed);
                deleted += half;
            } while (half != 0L);
            long stopTime = System.currentTimeMillis();
            long elapsed = (stopTime - startTime) / 1000L;
            log.info("deleted " + deleted + " values in " + elapsed + " seconds");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RowColumn
    implements Comparable<RowColumn> {
        Text row;
        Column column;
        long timestamp;

        public RowColumn(Text row, Column column, long timestamp) {
            this.row = row;
            this.column = column;
            this.timestamp = timestamp;
        }

        public int hashCode() {
            return Objects.hashCode(this.row) + Objects.hashCode(this.column);
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj instanceof RowColumn && 0 == this.compareTo((RowColumn)obj);
        }

        @Override
        public int compareTo(RowColumn other) {
            int result = this.row.compareTo((BinaryComparable)other.row);
            if (result != 0) {
                return result;
            }
            return this.column.compareTo(other.column);
        }

        public String toString() {
            return this.row.toString() + ":" + this.column.toString();
        }
    }
}

