/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class DetectDeadTabletServersIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        log.info("verifying that everything is up");
        Iterators.size((Iterator)c.createScanner("accumulo.metadata", Authorizations.EMPTY).iterator());
        MasterMonitorInfo stats = this.getStats(c);
        Assert.assertEquals((long)2L, (long)stats.tServerInfo.size());
        Assert.assertEquals((long)0L, (long)stats.badTServers.size());
        Assert.assertEquals((long)0L, (long)stats.deadTabletServers.size());
        log.info("Killing a tablet server");
        this.getCluster().killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
        while (true) {
            stats = this.getStats(c);
            if (2 != stats.tServerInfo.size()) break;
            UtilWaitThread.sleep((long)500L);
        }
        Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
        Assert.assertEquals((long)1L, (long)(stats.badTServers.size() + stats.deadTabletServers.size()));
        while (true) {
            stats = this.getStats(c);
            if (0 != stats.deadTabletServers.size()) break;
            UtilWaitThread.sleep((long)500L);
        }
        Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
        Assert.assertEquals((long)0L, (long)stats.badTServers.size());
        Assert.assertEquals((long)1L, (long)stats.deadTabletServers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterMonitorInfo getStats(Connector c) throws Exception {
        Credentials creds = new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        ClientContext context = new ClientContext(c.getInstance(), creds, this.getClientConfig());
        MasterClientService.Client client = null;
        try {
            client = MasterClient.getConnectionWithRetry((ClientContext)context);
            log.info("Fetching master stats");
            MasterMonitorInfo masterMonitorInfo = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
            return masterMonitorInfo;
        }
        finally {
            if (client != null) {
                MasterClient.close((MasterClientService.Iface)client);
            }
        }
    }
}

