/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanWalIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(CleanWalIT.class);

    @Override
    public int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Before
    public void offlineTraceTable() throws Exception {
        Connector conn = this.getConnector();
        String traceTable = (String)conn.instanceOperations().getSystemConfiguration().get(Property.TRACE_TABLE.getKey());
        if (conn.tableOperations().exists(traceTable)) {
            conn.tableOperations().offline(traceTable, true);
        }
    }

    @After
    public void onlineTraceTable() throws Exception {
        if (null != cluster) {
            Connector conn = this.getConnector();
            String traceTable = (String)conn.instanceOperations().getSystemConfiguration().get(Property.TRACE_TABLE.getKey());
            if (conn.tableOperations().exists(traceTable)) {
                conn.tableOperations().online(traceTable, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        for (String table : new String[]{"accumulo.metadata", "accumulo.root"}) {
            conn.tableOperations().flush(table, null, null, true);
        }
        log.debug("Checking entries for " + tableName);
        Assert.assertEquals((long)1L, (long)this.count(tableName, conn));
        for (String table : new String[]{"accumulo.metadata", "accumulo.root"}) {
            log.debug("Checking logs for " + table);
            Assert.assertEquals((String)("Found logs for " + table), (long)0L, (long)this.countLogs(table, conn));
        }
        bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        m = new Mutation((CharSequence)"row");
        m.putDelete((CharSequence)"cf", (CharSequence)"cq");
        bw.addMutation(m);
        bw.close();
        Assert.assertEquals((long)0L, (long)this.count(tableName, conn));
        conn.tableOperations().flush(tableName, null, null, true);
        conn.tableOperations().flush("accumulo.metadata", null, null, true);
        conn.tableOperations().flush("accumulo.root", null, null, true);
        try {
            CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
        Assert.assertEquals((long)0L, (long)this.count(tableName, conn));
    }

    private int countLogs(String tableName, Connector conn) throws TableNotFoundException {
        Scanner scanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        scanner.setRange(MetadataSchema.TabletsSection.getRange());
        int count = 0;
        for (Map.Entry entry : scanner) {
            log.debug("Saw " + entry.getKey() + "=" + entry.getValue());
            ++count;
        }
        return count;
    }

    int count(String tableName, Connector conn) throws Exception {
        Scanner s = conn.createScanner(tableName, Authorizations.EMPTY);
        return Iterators.size((Iterator)s.iterator());
    }
}

