/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.hadoop.minikdc.MiniKdc;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingKdc {
    private static final Logger log = LoggerFactory.getLogger(TestingKdc.class);
    public static final int NUM_USERS = 10;
    public static final long MAX_TICKET_LIFETIME_MILLIS = 86400000L;
    protected MiniKdc kdc = null;
    protected ClusterUser accumuloServerUser = null;
    protected ClusterUser accumuloAdmin = null;
    protected List<ClusterUser> clientPrincipals = null;
    public final String ORG_NAME = "EXAMPLE";
    public final String ORG_DOMAIN = "COM";
    private String hostname;
    private File keytabDir;
    private boolean started = false;

    public TestingKdc() throws Exception {
        this(TestingKdc.computeKdcDir(), TestingKdc.computeKeytabDir(), 86400000L);
    }

    public static File computeKdcDir() {
        File targetDir = new File(System.getProperty("user.dir"), "target");
        if (!targetDir.exists()) {
            Assert.assertTrue((boolean)targetDir.mkdirs());
        }
        Assert.assertTrue((String)("Could not find Maven target directory: " + targetDir), (targetDir.exists() && targetDir.isDirectory() ? 1 : 0) != 0);
        File kdcDir = new File(new File(targetDir, "kerberos"), "minikdc");
        Assert.assertTrue((kdcDir.mkdirs() || kdcDir.isDirectory() ? 1 : 0) != 0);
        return kdcDir;
    }

    public static File computeKeytabDir() {
        File targetDir = new File(System.getProperty("user.dir"), "target");
        Assert.assertTrue((String)("Could not find Maven target directory: " + targetDir), (targetDir.exists() && targetDir.isDirectory() ? 1 : 0) != 0);
        File keytabDir = new File(new File(targetDir, "kerberos"), "keytabs");
        Assert.assertTrue((keytabDir.mkdirs() || keytabDir.isDirectory() ? 1 : 0) != 0);
        return keytabDir;
    }

    public TestingKdc(File kdcDir, File keytabDir) throws Exception {
        this(kdcDir, keytabDir, 86400000L);
    }

    public TestingKdc(File kdcDir, File keytabDir, long maxTicketLifetime) throws Exception {
        Objects.requireNonNull(kdcDir, "KDC directory was null");
        Objects.requireNonNull(keytabDir, "Keytab directory was null");
        Preconditions.checkArgument((maxTicketLifetime > 0L ? 1 : 0) != 0, (Object)"Ticket lifetime must be positive");
        this.keytabDir = keytabDir;
        this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
        log.debug("Starting MiniKdc in {} with keytabs in {}", (Object)kdcDir, (Object)keytabDir);
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("org.name", "EXAMPLE");
        kdcConf.setProperty("org.domain", "COM");
        kdcConf.setProperty("max.ticket.lifetime", Long.toString(maxTicketLifetime));
        this.kdc = new MiniKdc(kdcConf, kdcDir);
    }

    public synchronized void start() throws Exception {
        Preconditions.checkArgument((!this.started ? 1 : 0) != 0, (Object)"KDC was already started");
        this.kdc.start();
        Thread.sleep(1000L);
        File accumuloKeytab = new File(this.keytabDir, "accumulo.keytab");
        String accumuloPrincipal = String.format("accumulo/%s", this.hostname);
        log.info("Creating Kerberos principal {} with keytab {}", (Object)accumuloPrincipal, (Object)accumuloKeytab);
        this.kdc.createPrincipal(accumuloKeytab, new String[]{accumuloPrincipal});
        this.accumuloServerUser = new ClusterUser(this.qualifyUser(accumuloPrincipal), accumuloKeytab);
        String rootPrincipal = "root";
        File rootKeytab = new File(this.keytabDir, rootPrincipal + ".keytab");
        log.info("Creating Kerberos principal {} with keytab {}", (Object)rootPrincipal, (Object)rootKeytab);
        this.kdc.createPrincipal(rootKeytab, new String[]{rootPrincipal});
        this.accumuloAdmin = new ClusterUser(this.qualifyUser(rootPrincipal), rootKeytab);
        this.clientPrincipals = new ArrayList<ClusterUser>(10);
        for (int i = 1; i <= 10; ++i) {
            String clientPrincipal = "client" + i;
            File clientKeytab = new File(this.keytabDir, clientPrincipal + ".keytab");
            log.info("Creating Kerberos principal {} with keytab {}", (Object)clientPrincipal, (Object)clientKeytab);
            this.kdc.createPrincipal(clientKeytab, new String[]{clientPrincipal});
            this.clientPrincipals.add(new ClusterUser(this.qualifyUser(clientPrincipal), clientKeytab));
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        Preconditions.checkArgument((boolean)this.started, (Object)"KDC is not started");
        this.kdc.stop();
        this.started = false;
    }

    public File getKeytabDir() {
        return this.keytabDir;
    }

    public ClusterUser getAccumuloServerUser() {
        Preconditions.checkArgument((boolean)this.started, (Object)"The KDC is not started");
        return this.accumuloServerUser;
    }

    public ClusterUser getRootUser() {
        Preconditions.checkArgument((boolean)this.started, (Object)"The KDC is not started");
        return this.accumuloAdmin;
    }

    public ClusterUser getClientPrincipal(int offset) {
        Preconditions.checkArgument((boolean)this.started, (Object)"Client principal is not initialized, is the KDC started?");
        Preconditions.checkArgument((offset >= 0 && offset < 10 ? 1 : 0) != 0, (Object)"Offset is invalid, must be non-negative and less than 10");
        return this.clientPrincipals.get(offset);
    }

    public void createPrincipal(File keytabFile, String ... principals) throws Exception {
        Preconditions.checkArgument((boolean)this.started, (Object)"KDC is not started");
        this.kdc.createPrincipal(keytabFile, principals);
    }

    public String getOrgName() {
        return "EXAMPLE";
    }

    public String getOrgDomain() {
        return "COM";
    }

    public String qualifyUser(String primary) {
        return String.format("%s@%s.%s", primary, this.getOrgName(), this.getOrgDomain());
    }
}

