/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.ClusterUsers;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public abstract class SharedMiniClusterBase
extends AccumuloITBase
implements ClusterUsers {
    private static final Logger log = LoggerFactory.getLogger(SharedMiniClusterBase.class);
    public static final String TRUE = Boolean.toString(true);
    private static String principal = "root";
    private static String rootPassword;
    private static AuthenticationToken token;
    private static MiniAccumuloClusterImpl cluster;
    private static TestingKdc krb;

    public static void startMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(MiniClusterConfigurationCallback.NO_CALLBACK);
    }

    public static void startMiniClusterWithConfig(MiniClusterConfigurationCallback miniClusterCallback) throws Exception {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assert.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        MiniClusterHarness harness = new MiniClusterHarness();
        if (TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"))) {
            krb = new TestingKdc();
            krb.start();
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            ClusterUser rootUser = krb.getRootUser();
            UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            token = new KerberosToken();
        } else {
            rootPassword = "rootPasswordShared1";
            token = new PasswordToken((CharSequence)rootPassword);
        }
        cluster = harness.create(SharedMiniClusterBase.class.getName(), System.currentTimeMillis() + "_" + new Random().nextInt(Short.MAX_VALUE), token, miniClusterCallback, krb);
        cluster.start();
        if (null != krb) {
            String traceTable = Property.TRACE_TABLE.getDefaultValue();
            ClusterUser systemUser = krb.getAccumuloServerUser();
            ClusterUser rootUser = krb.getRootUser();
            UserGroupInformation.loginUserFromKeytab((String)systemUser.getPrincipal(), (String)systemUser.getKeytab().getAbsolutePath());
            Connector conn = cluster.getConnector(systemUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            conn = cluster.getConnector(principal, token);
            conn.tableOperations().create(traceTable);
            conn.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.READ);
            conn.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.WRITE);
            conn.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.ALTER_TABLE);
        }
    }

    public static void stopMiniCluster() throws Exception {
        if (null != cluster) {
            try {
                cluster.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop minicluster", (Throwable)e);
            }
        }
        if (null != krb) {
            try {
                krb.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop KDC", (Throwable)e);
            }
        }
    }

    public static String getRootPassword() {
        return rootPassword;
    }

    public static AuthenticationToken getToken() {
        if (token instanceof KerberosToken) {
            try {
                UserGroupInformation.loginUserFromKeytab((String)SharedMiniClusterBase.getPrincipal(), (String)krb.getRootUser().getKeytab().getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to login", e);
            }
        }
        return token;
    }

    public static String getPrincipal() {
        return principal;
    }

    public static MiniAccumuloClusterImpl getCluster() {
        return cluster;
    }

    public static File getMiniClusterDir() {
        return cluster.getConfig().getDir();
    }

    public static Connector getConnector() {
        try {
            return SharedMiniClusterBase.getCluster().getConnector(principal, SharedMiniClusterBase.getToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TestingKdc getKdc() {
        return krb;
    }

    public ClusterUser getAdminUser() {
        if (null == krb) {
            return new ClusterUser(SharedMiniClusterBase.getPrincipal(), SharedMiniClusterBase.getRootPassword());
        }
        return krb.getRootUser();
    }

    public ClusterUser getUser(int offset) {
        if (null == krb) {
            String user = SharedMiniClusterBase.class.getName() + "_" + this.testName.getMethodName() + "_" + offset;
            return new ClusterUser(user, user);
        }
        return krb.getClientPrincipal(offset);
    }
}

