/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.tserver.tablet.CompactionInfo;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.slf4j.LoggerFactory;

public class CompactionWatcher
implements Runnable {
    private final Map<List<Long>, ObservedCompactionInfo> observedCompactions = new HashMap<List<Long>, ObservedCompactionInfo>();
    private final AccumuloConfiguration config;
    private static boolean watching = false;

    public CompactionWatcher(AccumuloConfiguration config) {
        this.config = config;
    }

    @Override
    public void run() {
        List<CompactionInfo> runningCompactions = Compactor.getRunningCompactions();
        HashSet<List<Long>> newKeys = new HashSet<List<Long>>();
        long time = System.currentTimeMillis();
        for (CompactionInfo compactionInfo : runningCompactions) {
            List<Long> compactionKey = Arrays.asList(compactionInfo.getID(), compactionInfo.getEntriesRead(), compactionInfo.getEntriesWritten());
            newKeys.add(compactionKey);
            if (this.observedCompactions.containsKey(compactionKey)) continue;
            this.observedCompactions.put(compactionKey, new ObservedCompactionInfo(compactionInfo, time));
        }
        HashMap<List<Long>, ObservedCompactionInfo> copy = new HashMap<List<Long>, ObservedCompactionInfo>(this.observedCompactions);
        copy.keySet().removeAll(newKeys);
        for (ObservedCompactionInfo oci : copy.values()) {
            if (!oci.loggedWarning) continue;
            LoggerFactory.getLogger(CompactionWatcher.class).info("Compaction of " + oci.compactionInfo.getExtent() + " is no longer stuck");
        }
        this.observedCompactions.keySet().retainAll(newKeys);
        long l = this.config.getTimeInMillis(Property.TSERV_COMPACTION_WARN_TIME);
        for (ObservedCompactionInfo oci : this.observedCompactions.values()) {
            Thread compactionThread;
            if (time - oci.firstSeen <= l || oci.loggedWarning || (compactionThread = oci.compactionInfo.getThread()) == null) continue;
            StackTraceElement[] trace = compactionThread.getStackTrace();
            Exception e = new Exception("Possible stack trace of compaction stuck on " + oci.compactionInfo.getExtent());
            e.setStackTrace(trace);
            LoggerFactory.getLogger(CompactionWatcher.class).warn("Compaction of " + oci.compactionInfo.getExtent() + " to " + oci.compactionInfo.getOutputFile() + " has not made progress for at least " + (time - oci.firstSeen) + "ms", (Throwable)e);
            oci.loggedWarning = true;
        }
    }

    public static synchronized void startWatching(AccumuloConfiguration config) {
        if (!watching) {
            SimpleTimer.getInstance((AccumuloConfiguration)config).schedule((Runnable)new CompactionWatcher(config), 10000L, 10000L);
            watching = true;
        }
    }

    private static class ObservedCompactionInfo {
        CompactionInfo compactionInfo;
        long firstSeen;
        boolean loggedWarning;

        ObservedCompactionInfo(CompactionInfo ci, long time) {
            this.compactionInfo = ci;
            this.firstSeen = time;
        }
    }
}

