/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.ProbabilitySampler;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.gc.GarbageCollectWriteAheadLogs;
import org.apache.accumulo.gc.GarbageCollectionAlgorithm;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.gc.metrics.GcCycleMetrics;
import org.apache.accumulo.gc.metrics.GcMetrics;
import org.apache.accumulo.gc.replication.CloseWriteAheadLogReferences;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.rpc.RpcWrapper;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TCredentialsUpdatingWrapper;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGarbageCollector
extends AccumuloServerContext
implements GCMonitorService.Iface {
    private static final Text EMPTY_TEXT = new Text();
    static final float CANDIDATE_MEMORY_PERCENTAGE = 0.5f;
    private static final Logger log = LoggerFactory.getLogger(SimpleGarbageCollector.class);
    private VolumeManager fs;
    private Opts opts = new Opts();
    private ZooLock lock;
    private GCStatus status = new GCStatus(new GcCycleStats(), new GcCycleStats(), new GcCycleStats(), new GcCycleStats());
    private GcCycleMetrics gcCycleMetrics = new GcCycleMetrics();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws UnknownHostException, IOException {
        String app = "gc";
        Accumulo.setupLogging((String)"gc");
        SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
        Instance instance = HdfsZooInstance.getInstance();
        ServerConfigurationFactory conf = new ServerConfigurationFactory(instance);
        log.info("Version 1.10.4");
        log.info("Instance " + instance.getInstanceID());
        VolumeManager fs = VolumeManagerImpl.get();
        MetricsSystemHelper.configure((String)SimpleGarbageCollector.class.getSimpleName());
        Accumulo.init((VolumeManager)fs, (ServerConfigurationFactory)conf, (String)"gc");
        Opts opts = new Opts();
        opts.parseArgs("gc", args, new Object[0]);
        SimpleGarbageCollector gc = new SimpleGarbageCollector(opts, fs, conf);
        DistributedTrace.enable((String)opts.getAddress(), (String)"gc", (AccumuloConfiguration)conf.getConfiguration());
        try {
            gc.run();
        }
        finally {
            DistributedTrace.disable();
        }
    }

    public SimpleGarbageCollector(Opts opts, VolumeManager fs, ServerConfigurationFactory confFactory) {
        super(confFactory);
        this.opts = opts;
        this.fs = fs;
        AccumuloConfiguration conf = this.getConfiguration();
        GcMetrics gcMetrics = new GcMetrics(this, conf.getBoolean(Property.GC_METRICS_ENABLED));
        try {
            if (gcMetrics.isEnabled()) {
                gcMetrics.register();
                log.info("gc metrics: registered with metrics system");
            } else {
                log.info("gc metrics: disabled. Set GC_METRICS_ENABLED property to true for detailed gc metrics");
            }
        }
        catch (Exception ex) {
            log.info("gc metrics: Failed to register gc metrics module", (Throwable)ex);
        }
        long gcDelay = conf.getTimeInMillis(Property.GC_CYCLE_DELAY);
        String useFullCompaction = conf.get(Property.GC_USE_FULL_COMPACTION);
        log.info("start delay: {} milliseconds", (Object)this.getStartDelay());
        log.info("time delay: {} milliseconds", (Object)gcDelay);
        log.info("safemode: {}", (Object)opts.safeMode);
        log.info("verbose: {}", (Object)opts.verbose);
        log.info("memory threshold: {} of {} bytes", (Object)Float.valueOf(0.5f), (Object)Runtime.getRuntime().maxMemory());
        log.info("delete threads: {}", (Object)this.getNumDeleteThreads());
        log.info("gc post metadata action: {}", (Object)useFullCompaction);
    }

    long getStartDelay() {
        return this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_START);
    }

    VolumeManager getVolumeManager() {
        return this.fs;
    }

    boolean isUsingTrash() {
        return !this.getConfiguration().getBoolean(Property.GC_TRASH_IGNORE);
    }

    Opts getOpts() {
        return this.opts;
    }

    int getNumDeleteThreads() {
        return this.getConfiguration().getCount(Property.GC_DELETE_THREADS);
    }

    boolean shouldArchiveFiles() {
        return this.getConfiguration().getBoolean(Property.GC_FILE_ARCHIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        log.info("Trying to acquire ZooKeeper lock for garbage collector");
        try {
            this.getZooLock(this.startStatsService());
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            System.exit(1);
        }
        try {
            long delay = this.getStartDelay();
            log.debug("Sleeping for " + delay + " milliseconds before beginning garbage collection cycles");
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
            return;
        }
        ProbabilitySampler sampler = new ProbabilitySampler(this.getConfiguration().getFraction(Property.GC_TRACE_PERCENT));
        LiveTServerSet liveTServerSet = new LiveTServerSet((ClientContext)this, new LiveTServerSet.Listener(){

            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                log.debug("Number of current servers {}, tservers added {}, removed {}", new Object[]{current == null ? -1 : current.size(), added, deleted});
                if (log.isTraceEnabled()) {
                    log.trace("Current servers: {}\nAdded: {}\n Removed: {}", new Object[]{current, added, deleted});
                }
            }
        });
        while (true) {
            Trace.on((String)"gc", (Sampler)sampler);
            Span gcSpan = Trace.start((String)"loop");
            long tStart = System.nanoTime();
            try {
                System.gc();
                this.status.current.started = System.currentTimeMillis();
                new GarbageCollectionAlgorithm().collect(new GCEnv("accumulo.root"));
                new GarbageCollectionAlgorithm().collect(new GCEnv("accumulo.metadata"));
                log.info("Number of data file candidates for deletion: " + this.status.current.candidates);
                log.info("Number of data file candidates still in use: " + this.status.current.inUse);
                log.info("Number of successfully deleted data files: " + this.status.current.deleted);
                log.info("Number of data files delete failures: " + this.status.current.errors);
                this.status.current.finished = System.currentTimeMillis();
                this.status.last = this.status.current;
                this.gcCycleMetrics.setLastCollect(this.status.current);
                this.status.current = new GcCycleStats();
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            long tStop = System.nanoTime();
            log.info(String.format("Collect cycle took %.2f seconds", (double)TimeUnit.NANOSECONDS.toMillis(tStop - tStart) / 1000.0));
            Span replSpan = Trace.start((String)"replicationClose");
            try {
                CloseWriteAheadLogReferences closeWals = new CloseWriteAheadLogReferences(this);
                closeWals.run();
            }
            catch (Exception e) {
                log.error("Error trying to close write-ahead logs for replication table", (Throwable)e);
            }
            finally {
                replSpan.stop();
            }
            Span waLogs = Trace.start((String)"walogs");
            try {
                GarbageCollectWriteAheadLogs walogCollector = new GarbageCollectWriteAheadLogs(this, this.fs, liveTServerSet, this.isUsingTrash());
                log.info("Beginning garbage collection of write-ahead logs");
                walogCollector.collect(this.status);
                this.gcCycleMetrics.setLastWalCollect(this.status.lastLog);
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                waLogs.stop();
            }
            gcSpan.stop();
            try {
                Connector connector = this.getConnector();
                long actionStart = System.nanoTime();
                String action = this.getConfiguration().get(Property.GC_USE_FULL_COMPACTION);
                log.debug("gc post action {} started", (Object)action);
                switch (action) {
                    case "compact": {
                        connector.tableOperations().compact("accumulo.metadata", null, null, true, true);
                        connector.tableOperations().compact("accumulo.root", null, null, true, true);
                        break;
                    }
                    case "flush": {
                        connector.tableOperations().flush("accumulo.metadata", null, null, true);
                        connector.tableOperations().flush("accumulo.root", null, null, true);
                        break;
                    }
                    default: {
                        log.trace("'none - no gc post action' or invalid value provided: {}", (Object)action);
                    }
                }
                long actionComplete = System.nanoTime();
                this.gcCycleMetrics.setPostOpDurationNanos(actionComplete - actionStart);
                log.info("gc post action {} completed in {} seconds", (Object)action, (Object)String.format("%.2f", (double)TimeUnit.NANOSECONDS.toMillis(actionComplete - actionStart) / 1000.0));
            }
            catch (Exception e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
            Trace.off();
            try {
                this.gcCycleMetrics.incrementRunCycleCount();
                log.info("GC Cycle Metrics: {}", (Object)this.gcCycleMetrics);
                long gcDelay = this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
                log.debug("Sleeping for " + gcDelay + " milliseconds");
                Thread.sleep(gcDelay);
            }
            catch (InterruptedException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
                return;
            }
        }
    }

    boolean archiveOrMoveToTrash(Path path) throws IOException {
        if (this.shouldArchiveFiles()) {
            return this.archiveFile(path);
        }
        if (!this.isUsingTrash()) {
            return false;
        }
        try {
            return this.fs.moveToTrash(path);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    boolean archiveFile(Path fileToArchive) throws IOException {
        Volume sourceVolume = this.fs.getVolumeByPath(fileToArchive);
        String sourceVolumeBasePath = sourceVolume.getBasePath();
        log.debug("Base path for volume: " + sourceVolumeBasePath);
        String sourcePathBasePath = fileToArchive.toUri().getPath();
        String relativeVolumePath = sourcePathBasePath.substring(sourceVolumeBasePath.length());
        if ('/' == relativeVolumePath.charAt(0)) {
            relativeVolumePath = relativeVolumePath.length() > 1 ? relativeVolumePath.substring(1) : "";
        }
        log.debug("Computed relative path for file to archive: " + relativeVolumePath);
        Path archivePath = new Path(sourceVolumeBasePath, "fileArchive");
        log.debug("File archive path: " + archivePath);
        this.fs.mkdirs(archivePath);
        Path fileArchivePath = new Path(archivePath, relativeVolumePath);
        log.debug("Create full path of " + fileArchivePath + " from " + archivePath + " and " + relativeVolumePath);
        if (this.fs.exists(fileArchivePath)) {
            log.warn("Tried to archive file, but it already exists: " + fileArchivePath);
            return false;
        }
        log.debug("Moving " + fileToArchive + " to " + fileArchivePath);
        return this.fs.rename(fileToArchive, fileArchivePath);
    }

    private void getZooLock(HostAndPort addr) throws KeeperException, InterruptedException {
        String path = ZooUtil.getRoot((Instance)this.getInstance()) + "/gc/lock";
        ZooLock.LockWatcher lockWatcher = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                Halt.halt((String)("GC lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)1);
            }

            public void unableToMonitorLockNode(final Throwable e) {
                Halt.halt((int)-1, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        log.error("FATAL: No longer able to monitor lock node ", e);
                    }
                });
            }
        };
        while (true) {
            this.lock = new ZooLock(path);
            if (this.lock.tryLock(lockWatcher, new ServerServices(addr.toString(), ServerServices.Service.GC_CLIENT).toString().getBytes())) {
                log.debug("Got GC ZooKeeper lock");
                return;
            }
            log.debug("Failed to get GC ZooKeeper lock, will retry");
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private HostAndPort startStatsService() throws UnknownHostException {
        GCMonitorService.Processor processor;
        GCMonitorService.Iface rpcProxy = (GCMonitorService.Iface)RpcWrapper.service((Object)((Object)this), (TBaseProcessor)new GCMonitorService.Processor((GCMonitorService.Iface)this));
        if (ThriftServerType.SASL == this.getThriftServerType()) {
            GCMonitorService.Iface tcProxy = (GCMonitorService.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, ((Object)((Object)this)).getClass(), (AccumuloConfiguration)this.getConfiguration());
            processor = new GCMonitorService.Processor(tcProxy);
        } else {
            processor = new GCMonitorService.Processor(rpcProxy);
        }
        int[] port = this.getConfiguration().getPort(Property.GC_PORT);
        HostAndPort[] addresses = TServerUtils.getHostAndPorts((String)this.opts.getAddress(), (int[])port);
        long maxMessageSize = this.getConfiguration().getMemoryInBytes(Property.GENERAL_MAX_MESSAGE_SIZE);
        try {
            ServerAddress server = TServerUtils.startTServer((AccumuloConfiguration)this.getConfiguration(), (ThriftServerType)this.getThriftServerType(), (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"GC Monitor Service", (int)2, (int)this.getConfiguration().getCount(Property.GENERAL_SIMPLETIMER_THREADPOOL_SIZE), (long)1000L, (long)maxMessageSize, (SslConnectionParams)this.getServerSslParams(), (SaslServerConnectionParams)this.getSaslParams(), (long)0L, (HostAndPort[])addresses);
            log.debug("Starting garbage collector listening on " + server.address);
            return server.address;
        }
        catch (Exception ex) {
            log.error("FATAL:", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    static boolean almostOutOfMemory(Runtime runtime) {
        return (float)(runtime.totalMemory() - runtime.freeMemory()) > 0.5f * (float)runtime.maxMemory();
    }

    private static void putMarkerDeleteMutation(String delete, BatchWriter writer) throws MutationsRejectedException {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.DeletesSection.getRowPrefix() + delete));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        writer.addMutation(m);
    }

    static boolean isDir(String delete) {
        if (delete == null) {
            return false;
        }
        int slashCount = 0;
        for (int i = 0; i < delete.length(); ++i) {
            if (delete.charAt(i) != '/') continue;
            ++slashCount;
        }
        return slashCount == 1;
    }

    public GCStatus getStatus(TInfo info, TCredentials credentials) {
        return this.status;
    }

    public GcCycleMetrics getGcCycleMetrics() {
        return this.gcCycleMetrics;
    }

    private class GCEnv
    implements GarbageCollectionEnvironment {
        private String tableName;

        GCEnv(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public boolean getCandidates(String continuePoint, List<String> result) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            Range range = MetadataSchema.DeletesSection.getRange();
            if (continuePoint != null && !continuePoint.isEmpty()) {
                String continueRow = MetadataSchema.DeletesSection.getRowPrefix() + continuePoint;
                range = new Range(new Key((CharSequence)continueRow).followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
            }
            Scanner scanner = SimpleGarbageCollector.this.getConnector().createScanner(this.tableName, Authorizations.EMPTY);
            scanner.setRange(range);
            result.clear();
            for (Map.Entry entry : scanner) {
                String cand = ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.DeletesSection.getRowPrefix().length());
                result.add(cand);
                if (!SimpleGarbageCollector.almostOutOfMemory(Runtime.getRuntime())) continue;
                log.info("List of delete candidates has exceeded the memory threshold. Attempting to delete what has been gathered so far.");
                return true;
            }
            return false;
        }

        @Override
        public Iterator<String> getBlipIterator() throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            IsolatedScanner scanner = new IsolatedScanner(SimpleGarbageCollector.this.getConnector().createScanner(this.tableName, Authorizations.EMPTY));
            scanner.setRange(MetadataSchema.BlipSection.getRange());
            return Iterators.transform((Iterator)scanner.iterator(), entry -> ((Key)entry.getKey()).getRow().toString().substring(MetadataSchema.BlipSection.getRowPrefix().length()));
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> getReferenceIterator() throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
            IsolatedScanner scanner = new IsolatedScanner(SimpleGarbageCollector.this.getConnector().createScanner(this.tableName, Authorizations.EMPTY));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            TabletIterator tabletIterator = new TabletIterator((Scanner)scanner, MetadataSchema.TabletsSection.getRange(), true, true);
            return Iterators.concat((Iterator)Iterators.transform((Iterator)tabletIterator, input -> input.entrySet().iterator()));
        }

        @Override
        public Set<String> getTableIDs() {
            return Tables.getIdToNameMap((Instance)SimpleGarbageCollector.this.getInstance()).keySet();
        }

        @Override
        public void delete(SortedMap<String, String> confirmedDeletes) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
            if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.safeMode) {
                if (((SimpleGarbageCollector)SimpleGarbageCollector.this).opts.verbose) {
                    System.out.println("SAFEMODE: There are " + confirmedDeletes.size() + " data file candidates marked for deletion.%n          Examine the log files to identify them.%n");
                }
                log.info("SAFEMODE: Listing all data file candidates for deletion");
                for (String s : confirmedDeletes.values()) {
                    log.info("SAFEMODE: " + s);
                }
                log.info("SAFEMODE: End candidates for deletion");
                return;
            }
            Connector c = SimpleGarbageCollector.this.getConnector();
            BatchWriter writer = c.createBatchWriter(this.tableName, new BatchWriterConfig());
            Iterator<Map.Entry<String, String>> cdIter = confirmedDeletes.entrySet().iterator();
            String lastDir = null;
            while (cdIter.hasNext()) {
                Map.Entry<String, String> entry = cdIter.next();
                String relPath = entry.getKey();
                String absPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, entry.getValue()).toString();
                if (SimpleGarbageCollector.isDir(relPath)) {
                    lastDir = absPath;
                    continue;
                }
                if (lastDir == null) continue;
                if (absPath.startsWith(lastDir)) {
                    log.debug("Ignoring " + entry.getValue() + " because " + lastDir + " exist");
                    try {
                        SimpleGarbageCollector.putMarkerDeleteMutation(entry.getValue(), writer);
                    }
                    catch (MutationsRejectedException e) {
                        throw new RuntimeException(e);
                    }
                    cdIter.remove();
                    continue;
                }
                lastDir = null;
            }
            final BatchWriter finalWriter = writer;
            ExecutorService deleteThreadPool = Executors.newFixedThreadPool(SimpleGarbageCollector.this.getNumDeleteThreads(), (ThreadFactory)new NamingThreadFactory("deleting"));
            final List replacements = ServerConstants.getVolumeReplacements();
            for (final String delete : confirmedDeletes.values()) {
                Runnable deleteTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            boolean removeFlag;
                            Path fullPath;
                            String switchedDelete = VolumeUtil.switchVolume((String)delete, (VolumeManager.FileType)VolumeManager.FileType.TABLE, (List)replacements);
                            if (switchedDelete != null) {
                                log.debug("Volume replaced " + delete + " -> " + switchedDelete);
                                fullPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, switchedDelete);
                            } else {
                                fullPath = SimpleGarbageCollector.this.fs.getFullPath(VolumeManager.FileType.TABLE, delete);
                            }
                            log.debug("Deleting " + fullPath);
                            if (SimpleGarbageCollector.this.archiveOrMoveToTrash(fullPath) || SimpleGarbageCollector.this.fs.deleteRecursively(fullPath)) {
                                removeFlag = true;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.deleted;
                                }
                            }
                            if (SimpleGarbageCollector.this.fs.exists(fullPath)) {
                                removeFlag = false;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                                }
                                log.warn("File exists, but was not deleted for an unknown reason: " + fullPath);
                            } else {
                                removeFlag = true;
                                SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                                synchronized (simpleGarbageCollector) {
                                    ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                                }
                                String[] parts = fullPath.toString().split("/tables")[1].split("/");
                                if (parts.length > 2) {
                                    String tableId = parts[1];
                                    String tabletDir = parts[2];
                                    TableManager.getInstance().updateTableStateCache(tableId);
                                    TableState tableState = TableManager.getInstance().getTableState(tableId);
                                    if (tableState != null && tableState != TableState.DELETING && !tabletDir.startsWith("c-")) {
                                        log.debug("File doesn't exist: " + fullPath);
                                    }
                                } else {
                                    log.warn("Very strange path name: " + delete);
                                }
                            }
                            if (removeFlag && finalWriter != null) {
                                SimpleGarbageCollector.putMarkerDeleteMutation(delete, finalWriter);
                            }
                        }
                        catch (Exception e) {
                            log.error("{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                };
                deleteThreadPool.execute(deleteTask);
            }
            deleteThreadPool.shutdown();
            try {
                while (!deleteThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e1) {
                log.error("{}", (Object)e1.getMessage(), (Object)e1);
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (MutationsRejectedException e) {
                    log.error("Problem removing entries from the metadata table: ", (Throwable)e);
                }
            }
        }

        @Override
        public void deleteTableDirIfEmpty(String tableID) throws IOException {
            for (String dir : ServerConstants.getTablesDirs()) {
                FileStatus[] tabletDirs;
                try {
                    tabletDirs = SimpleGarbageCollector.this.fs.listStatus(new Path(dir + "/" + tableID));
                }
                catch (FileNotFoundException ex) {
                    continue;
                }
                if (tabletDirs.length != 0) continue;
                Path p = new Path(dir + "/" + tableID);
                log.debug("Removing table dir " + p);
                if (SimpleGarbageCollector.this.archiveOrMoveToTrash(p)) continue;
                SimpleGarbageCollector.this.fs.delete(p);
            }
        }

        @Override
        public void incrementCandidatesStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.candidates += i;
        }

        @Override
        public void incrementInUseStat(long i) {
            ((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.inUse += i;
        }

        @Override
        public Iterator<Map.Entry<String, Replication.Status>> getReplicationNeededIterator() throws AccumuloException, AccumuloSecurityException {
            Connector conn = SimpleGarbageCollector.this.getConnector();
            try {
                Scanner s = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                return Iterators.transform((Iterator)s.iterator(), input -> {
                    Replication.Status stat;
                    String file = ((Key)input.getKey()).getRow().toString();
                    try {
                        stat = Replication.Status.parseFrom((byte[])((Value)input.getValue()).get());
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("Could not deserialize protobuf for: " + input.getKey());
                        stat = null;
                    }
                    return Maps.immutableEntry((Object)file, (Object)stat);
                });
            }
            catch (ReplicationTableOfflineException e) {
                return Collections.emptyIterator();
            }
        }
    }

    static class Opts
    extends ServerOpts {
        @Parameter(names={"-v", "--verbose"}, description="extra information will get printed to stdout also")
        boolean verbose = false;
        @Parameter(names={"-s", "--safemode"}, description="safe mode will not delete files")
        boolean safeMode = false;

        Opts() {
        }
    }
}

