/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;

public class CustomNonBlockingServer
extends THsHaServer {
    private final Field selectAcceptThreadField;

    public CustomNonBlockingServer(THsHaServer.Args args) {
        super(args);
        try {
            this.selectAcceptThreadField = TNonblockingServer.class.getDeclaredField("selectAcceptThread_");
            this.selectAcceptThreadField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access required field in Thrift code.", e);
        }
    }

    protected boolean startThreads() {
        try {
            CustomSelectAcceptThread selectAcceptThread_ = new CustomSelectAcceptThread((TNonblockingServerTransport)this.serverTransport_);
            this.selectAcceptThreadField.set((Object)this, (Object)selectAcceptThread_);
            selectAcceptThread_.start();
            return true;
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to start selector thread!", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Exception setting customer select thread in Thrift");
        }
    }

    private class CustomFrameBuffer
    extends AbstractNonblockingServer.FrameBuffer {
        public CustomFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) {
            super((AbstractNonblockingServer)CustomNonBlockingServer.this, trans, selectionKey, selectThread);
        }

        public void invoke() {
            if (this.trans_ instanceof TNonblockingSocket) {
                TNonblockingSocket tsock = (TNonblockingSocket)this.trans_;
                Socket sock = tsock.getSocketChannel().socket();
                TServerUtils.clientAddress.set(sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
            }
            super.invoke();
        }
    }

    private class CustomSelectAcceptThread
    extends TNonblockingServer.SelectAcceptThread {
        public CustomSelectAcceptThread(TNonblockingServerTransport serverTransport) throws IOException {
            super((TNonblockingServer)CustomNonBlockingServer.this, serverTransport);
        }

        protected AbstractNonblockingServer.FrameBuffer createFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) {
            if (CustomNonBlockingServer.this.processorFactory_.isAsyncProcessor()) {
                throw new IllegalStateException("This implementation does not support AsyncProcessors");
            }
            return new CustomFrameBuffer(trans, selectionKey, selectThread);
        }
    }
}

