/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.BulkImportListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListBulkCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;

    @Override
    public String description() {
        return "lists what bulk imports are currently running in accumulo.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        List<String> tservers;
        boolean paginate;
        MasterMonitorInfo stats;
        block5: {
            MasterClientService.Client client = null;
            try {
                AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(shellState.getInstance()));
                client = MasterClient.getConnectionWithRetry((ClientContext)context);
                stats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                if (client == null) break block5;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    MasterClient.close(client);
                }
                throw throwable;
            }
            MasterClient.close((MasterClientService.Iface)client);
        }
        boolean bl = paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        if (cl.hasOption(this.tserverOption.getOpt())) {
            tservers = new ArrayList();
            tservers.add(cl.getOptionValue(this.tserverOption.getOpt()));
        } else {
            tservers = Collections.emptyList();
        }
        shellState.printLines(new BulkImportListIterator(tservers, stats), paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server to list bulk imports");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

