/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HistoryCommand
extends Shell.Command {
    private Option clearHist;
    private Option disablePaginationOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.hasOption(this.clearHist.getOpt())) {
            shellState.getReader().getHistory().clear();
        } else {
            ListIterator source = shellState.getReader().getHistory().entries();
            Iterator historyIterator = Iterators.transform((Iterator)source, input -> String.format("%d: %s", input.index() + 1, input.value()));
            shellState.printLines(historyIterator, !cl.hasOption(this.disablePaginationOpt.getOpt()));
        }
        return 0;
    }

    @Override
    public String description() {
        return "generates a list of commands previously executed";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.clearHist = new Option("c", "clear", false, "clear history file");
        o.addOption(this.clearHist);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        o.addOption(this.disablePaginationOpt);
        return o;
    }
}

