/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import org.apache.accumulo.monitor.util.celltypes.NumberType;

public class ProgressChartType
extends NumberType<Double> {
    private static final long serialVersionUID = 1L;
    private double max;

    public ProgressChartType() {
        this(1.0);
    }

    public ProgressChartType(Double total) {
        this.max = total == null ? 1.0 : total;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        Double num = (Double)obj;
        return ProgressChartType.getChart(num, this.max);
    }

    public static String getChart(double num, double total) {
        StringBuilder result = new StringBuilder();
        double percent = 0.0;
        if (total != 0.0) {
            percent = num / total * 100.0;
        }
        int width = 0;
        width = percent < 1.0 ? 0 : (percent > 100.0 ? 100 : (int)percent);
        result.append("<div class='progress-chart'>");
        result.append("<div style='width: ").append(width).append("%;'></div>");
        result.append("</div>&nbsp;");
        result.append(percent < 1.0 && percent > 0.0 ? "&lt;1" : Integer.valueOf((int)percent)).append("%");
        return result.toString();
    }
}

