/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import org.apache.accumulo.core.util.Duration;
import org.apache.accumulo.monitor.util.celltypes.NumberType;

public class DurationType
extends NumberType<Long> {
    private static final long serialVersionUID = 1L;
    private Long errMin;
    private Long errMax;

    public DurationType() {
        this(null, null);
    }

    public DurationType(Long errMin, Long errMax) {
        this.errMin = errMin;
        this.errMax = errMax;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        Long millis = (Long)obj;
        if (this.errMin != null && this.errMax != null) {
            String numbers = Duration.format((long)millis);
            if (millis < this.errMin || millis > this.errMax) {
                return "<span class='error'>" + numbers + "</span>";
            }
            return numbers;
        }
        return Duration.format((long)millis);
    }
}

