/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets.trace;

import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.servlets.trace.Basic;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.celltypes.DurationType;
import org.apache.accumulo.monitor.util.celltypes.NumberType;
import org.apache.accumulo.monitor.util.celltypes.StringType;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;

public class Summary
extends Basic {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MINUTES = 10;

    int getMinutes(HttpServletRequest req) {
        return Summary.getIntParameter(req, "minutes", 10);
    }

    @Override
    public String getTitle(HttpServletRequest req) {
        return "Traces for the last " + this.getMinutes(req) + " minutes";
    }

    protected Range getRangeForTrace(long minutesSince) {
        long endTime = System.currentTimeMillis();
        long millisSince = minutesSince * 60L * 1000L;
        if (millisSince < minutesSince) {
            millisSince = endTime;
        }
        long startTime = endTime - millisSince;
        String startHexTime = Long.toHexString(startTime);
        String endHexTime = Long.toHexString(endTime);
        while (startHexTime.length() < endHexTime.length()) {
            startHexTime = "0" + startHexTime;
        }
        return new Range(new Text("start:" + startHexTime), new Text("start:" + endHexTime));
    }

    private void parseSpans(Scanner scanner, Map<String, Stats> summary) {
        for (Map.Entry entry : scanner) {
            RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
            Stats stats = summary.get(span.description);
            if (stats == null) {
                stats = new Stats();
                summary.put(span.description, stats);
            }
            stats.addSpan(span);
        }
    }

    @Override
    public void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) throws Exception {
        int minutes = this.getMinutes(req);
        Map.Entry<Scanner, UserGroupInformation> pair = this.getScanner(sb);
        final Scanner scanner = pair.getKey();
        if (scanner == null) {
            return;
        }
        Range range = this.getRangeForTrace(minutes);
        scanner.setRange(range);
        final TreeMap<String, Stats> summary = new TreeMap<String, Stats>();
        if (null != pair.getValue()) {
            pair.getValue().doAs((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Summary.this.parseSpans(scanner, summary);
                    return null;
                }
            });
        } else {
            this.parseSpans(scanner, summary);
        }
        Table trace = new Table("traceSummary", "All Traces");
        trace.addSortableColumn("Type", new ShowTypeLink(minutes), "Trace Type");
        trace.addSortableColumn("Total", new NumberType(), "Number of spans of this type");
        trace.addSortableColumn("min", new DurationType(), "Shortest span duration");
        trace.addSortableColumn("max", new DurationType(), "Longest span duration");
        trace.addSortableColumn("avg", new DurationType(), "Average span duration");
        trace.addSortableColumn("Histogram", new HistogramType(), "Counts of spans of different duration. Columns start at milliseconds, and each column is ten times longer: tens of milliseconds, seconds, tens of seconds, etc.");
        for (Map.Entry entry : summary.entrySet()) {
            Stats stat = (Stats)entry.getValue();
            trace.addRow(entry.getKey(), stat.count, stat.min, stat.max, stat.average(), stat);
        }
        trace.generate(req, sb);
    }

    private static class HistogramType
    extends StringType<Stats> {
        private static final long serialVersionUID = 1L;

        private HistogramType() {
        }

        @Override
        public String format(Object obj) {
            Stats stat = (Stats)obj;
            StringBuilder sb = new StringBuilder();
            sb.append("<table>");
            sb.append("<tr>");
            for (long count : stat.histogram) {
                if (count > 0L) {
                    sb.append(String.format("<td style='width:5em'>%d</td>", count));
                    continue;
                }
                sb.append("<td style='width:5em'>-</td>");
            }
            sb.append("</tr></table>");
            return sb.toString();
        }

        @Override
        public int compare(Stats o1, Stats o2) {
            for (int i = 0; i < o1.histogram.length; ++i) {
                long diff = o1.histogram[i] - o2.histogram[i];
                if (diff < 0L) {
                    return -1;
                }
                if (diff <= 0L) continue;
                return 1;
            }
            return 0;
        }
    }

    private static class ShowTypeLink
    extends StringType<String> {
        private static final long serialVersionUID = 1L;
        int minutes;

        public ShowTypeLink(int minutes) {
            this.minutes = minutes;
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "-";
            }
            String type = obj.toString();
            String encodedType = BasicServlet.encode(type);
            return String.format("<a href='/trace/listType?type=%s&minutes=%d'>%s</a>", encodedType, this.minutes, type);
        }
    }

    private static class Stats {
        int count;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long total = 0L;
        long[] histogram = new long[]{0L, 0L, 0L, 0L, 0L, 0L};

        private Stats() {
        }

        void addSpan(RemoteSpan span) {
            int index;
            ++this.count;
            long ms = span.stop - span.start;
            this.total += ms;
            this.min = Math.min(this.min, ms);
            this.max = Math.max(this.max, ms);
            for (index = 0; ms >= 10L && index < this.histogram.length; ms /= 10L, ++index) {
            }
            int n = index;
            this.histogram[n] = this.histogram[n] + 1L;
        }

        long average() {
            return this.total / (long)this.count;
        }
    }
}

