/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets.trace;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.servlets.trace.NullScanner;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.hadoop.security.UserGroupInformation;

abstract class Basic
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    Basic() {
    }

    public static String getStringParameter(HttpServletRequest req, String name, String defaultValue) {
        String result = req.getParameter(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static int getIntParameter(HttpServletRequest req, String name, int defaultMinutes) {
        String valueString = req.getParameter(name);
        if (valueString == null) {
            return defaultMinutes;
        }
        int result = 0;
        try {
            result = Integer.parseInt(valueString);
        }
        catch (NumberFormatException ex) {
            return defaultMinutes;
        }
        return result;
    }

    public static String dateString(long millis) {
        return TraceFormatter.formatDate((Date)new Date(millis));
    }

    protected Map.Entry<Scanner, UserGroupInformation> getScanner(StringBuilder sb) throws AccumuloException, AccumuloSecurityException {
        Scanner scanner;
        PasswordToken at;
        String principal;
        AccumuloConfiguration conf = Monitor.getContext().getConfiguration();
        boolean saslEnabled = conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED);
        UserGroupInformation traceUgi = null;
        Map loginMap = conf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX);
        String keytab = (String)loginMap.get(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey() + "keytab");
        if (keytab == null || keytab.length() == 0) {
            keytab = conf.getPath(Property.GENERAL_KERBEROS_KEYTAB);
        }
        if (saslEnabled && null != keytab) {
            principal = SecurityUtil.getServerPrincipal((String)conf.get(Property.TRACE_USER));
            try {
                traceUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to login as trace user", e);
            }
        } else {
            principal = conf.get(Property.TRACE_USER);
        }
        if (!saslEnabled) {
            if (loginMap.isEmpty()) {
                Property p = Property.TRACE_PASSWORD;
                at = new PasswordToken(conf.get(p).getBytes(StandardCharsets.UTF_8));
            } else {
                AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                int prefixLength = Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey().length();
                for (Map.Entry entry : loginMap.entrySet()) {
                    props.put(((String)entry.getKey()).substring(prefixLength), (CharSequence)entry.getValue());
                }
                AuthenticationToken token = (AuthenticationToken)Property.createInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.TRACE_TOKEN_TYPE, AuthenticationToken.class, (Object)new PasswordToken());
                token.init(props);
                at = token;
            }
        } else {
            at = null;
        }
        String table = conf.get(Property.TRACE_TABLE);
        if (null != traceUgi) {
            try {
                scanner = (Scanner)traceUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Scanner>((AuthenticationToken)at, table, principal, sb){
                    final /* synthetic */ AuthenticationToken val$at;
                    final /* synthetic */ String val$table;
                    final /* synthetic */ String val$principal;
                    final /* synthetic */ StringBuilder val$sb;
                    {
                        this.val$at = authenticationToken;
                        this.val$table = string;
                        this.val$principal = string2;
                        this.val$sb = stringBuilder;
                    }

                    @Override
                    public Scanner run() throws Exception {
                        AuthenticationToken token = this.val$at;
                        if (null == token) {
                            token = new KerberosToken();
                        }
                        return Basic.this.getScanner(this.val$table, this.val$principal, token, this.val$sb);
                    }
                });
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to obtain scanner", e);
            }
        } else {
            if (null == at) {
                throw new AssertionError((Object)"AuthenticationToken should not be null");
            }
            scanner = this.getScanner(table, principal, (AuthenticationToken)at, sb);
        }
        return new AbstractMap.SimpleEntry<Scanner, UserGroupInformation>(scanner, traceUgi);
    }

    private Scanner getScanner(String table, String principal, AuthenticationToken at, StringBuilder sb) throws AccumuloException, AccumuloSecurityException {
        try {
            Connector conn = HdfsZooInstance.getInstance().getConnector(principal, at);
            if (!conn.tableOperations().exists(table)) {
                return new NullScanner();
            }
            Scanner scanner = conn.createScanner(table, conn.securityOperations().getUserAuthorizations(principal));
            return scanner;
        }
        catch (AccumuloSecurityException ex) {
            sb.append("<h2>Unable to read trace table: check trace username and password configuration.</h2>\n");
            return null;
        }
        catch (TableNotFoundException ex) {
            return new NullScanner();
        }
    }
}

