/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.ProbabilitySampler;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.replication.FinishedWorkUpdater;
import org.apache.accumulo.master.replication.RemoveCompleteReplicationRecords;
import org.apache.accumulo.master.replication.StatusMaker;
import org.apache.accumulo.master.replication.WorkMaker;
import org.apache.htrace.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationDriver
extends Daemon {
    private static final Logger log = LoggerFactory.getLogger(ReplicationDriver.class);
    private final Master master;
    private final AccumuloConfiguration conf;
    private WorkMaker workMaker;
    private StatusMaker statusMaker;
    private FinishedWorkUpdater finishedWorkUpdater;
    private RemoveCompleteReplicationRecords rcrr;
    private Connector conn;

    public ReplicationDriver(Master master) {
        super("Replication Driver");
        this.master = master;
        this.conf = master.getConfiguration();
    }

    public void run() {
        ProbabilitySampler sampler = new ProbabilitySampler(this.conf.getFraction(Property.REPLICATION_TRACE_PERCENT));
        long millisToWait = this.conf.getTimeInMillis(Property.REPLICATION_DRIVER_DELAY);
        log.debug("Waiting " + millisToWait + "ms before starting main replication loop");
        UtilWaitThread.sleep((long)millisToWait);
        log.debug("Starting replication loop");
        while (this.master.stillMaster()) {
            if (null == this.workMaker) {
                try {
                    this.conn = this.master.getConnector();
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    log.warn("Error trying to get connector to process replication records", e);
                    UtilWaitThread.sleep((long)2000L);
                    continue;
                }
                this.statusMaker = new StatusMaker(this.conn, this.master.getFileSystem());
                this.workMaker = new WorkMaker(this.master, this.conn);
                this.finishedWorkUpdater = new FinishedWorkUpdater(this.conn);
                this.rcrr = new RemoveCompleteReplicationRecords(this.conn);
            }
            Trace.on((String)"masterReplicationDriver", (Sampler)sampler);
            try {
                this.statusMaker.run();
            }
            catch (Exception e) {
                log.error("Caught Exception trying to create Replication status records", (Throwable)e);
            }
            try {
                this.workMaker.run();
            }
            catch (Exception e) {
                log.error("Caught Exception trying to create Replication work records", (Throwable)e);
            }
            try {
                this.finishedWorkUpdater.run();
            }
            catch (Exception e) {
                log.error("Caught Exception trying to update Replication records using finished work records", (Throwable)e);
            }
            try {
                this.rcrr.run();
            }
            catch (Exception e) {
                log.error("Caught Exception trying to remove finished Replication records", (Throwable)e);
            }
            Trace.off();
            long sleepMillis = this.conf.getTimeInMillis(Property.MASTER_REPLICATION_SCAN_INTERVAL);
            log.trace("Sleeping for {}ms before re-running", (Object)sleepMillis);
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                log.error("Interrupted while sleeping", (Throwable)e);
            }
        }
    }
}

